/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.local;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.ApplicationLauncher;
import ch.cyberduck.core.local.ApplicationQuitCallback;
import ch.cyberduck.core.threading.DefaultThreadPool;
import ch.cyberduck.core.threading.ThreadPool;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class ExecApplicationLauncher
implements ApplicationLauncher {
    private static final Logger log = Logger.getLogger(ExecApplicationLauncher.class);
    private final Runtime runtime = Runtime.getRuntime();
    private final ThreadPool pool = new DefaultThreadPool("process", 1);

    @Override
    public boolean open(Local file) {
        try {
            this.runtime.exec(String.format("xdg-open %s", file.getAbsolute()));
            return true;
        }
        catch (IOException e) {
            log.warn((Object)String.format("Failure launching application %s", e.getMessage()));
            return false;
        }
    }

    @Override
    public boolean open(Local file, Application application, final ApplicationQuitCallback callback) {
        try {
            final Process process = this.runtime.exec(String.format("%s %s", application.getIdentifier(), file.getAbsolute()));
            this.pool.execute(new Callable<Boolean>(){

                @Override
                public Boolean call() throws IOException {
                    try {
                        process.waitFor();
                        callback.callback();
                        return true;
                    }
                    catch (InterruptedException e) {
                        log.warn((Object)String.format("Failure waiting for application %s to exit", process));
                        return false;
                    }
                }
            });
            return true;
        }
        catch (IOException e) {
            log.warn((Object)String.format("Failure launching application %s", e.getMessage()));
            return false;
        }
    }

    @Override
    public boolean open(Application application, String args) {
        try {
            this.runtime.exec(String.format("%s %s", application.getIdentifier(), args));
            return true;
        }
        catch (IOException e) {
            log.warn((Object)String.format("Failure launching application %s", e.getMessage()));
            return false;
        }
    }

    @Override
    public void bounce(Local file) {
    }
}

