/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.FactoryException;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.DisabledTransferPrompt;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferPrompt;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.log4j.Logger;

public class TransferPromptControllerFactory
extends Factory<TransferPrompt> {
    private static final Logger log = Logger.getLogger(TransferPromptControllerFactory.class);

    public TransferPrompt create(Controller c, Transfer transfer, SessionPool source, SessionPool destination) {
        String clazz = PreferencesFactory.get().getProperty(String.format("factory.transferpromptcallback.%s.class", transfer.getType().name()));
        if (null == clazz) {
            throw new FactoryException(String.format("No implementation given for factory %s", this.getClass().getSimpleName()));
        }
        try {
            Class<?> name = Class.forName(clazz);
            Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor(name, (Class[])new Class[]{c.getClass(), transfer.getClass(), source.getClass(), destination.getClass()});
            if (null == constructor) {
                log.warn((Object)String.format("No matching constructor for parameter %s", c.getClass()));
                return (TransferPrompt)name.newInstance();
            }
            return (TransferPrompt)constructor.newInstance(c, transfer, source, destination);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.error((Object)String.format("Failure loading callback class %s. %s", clazz, e.getMessage()));
            return new DisabledTransferPrompt();
        }
    }

    public static TransferPrompt get(Controller c, Transfer transfer, SessionPool source, SessionPool destination) {
        return new TransferPromptControllerFactory().create(c, transfer, source, destination);
    }
}

