/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.multipart;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.uuid.Generators;
import com.joyent.manta.client.MantaClient;
import com.joyent.manta.client.MantaMetadata;
import com.joyent.manta.client.MantaObject;
import com.joyent.manta.client.MantaObjectInputStream;
import com.joyent.manta.client.MantaObjectMapper;
import com.joyent.manta.client.MantaObjectResponse;
import com.joyent.manta.client.jobs.MantaJob;
import com.joyent.manta.client.jobs.MantaJobBuilder;
import com.joyent.manta.client.jobs.MantaJobPhase;
import com.joyent.manta.client.multipart.AbstractMultipartManager;
import com.joyent.manta.client.multipart.JobsMultipartUpload;
import com.joyent.manta.client.multipart.MantaMultipartStatus;
import com.joyent.manta.client.multipart.MantaMultipartUpload;
import com.joyent.manta.client.multipart.MantaMultipartUploadPart;
import com.joyent.manta.client.multipart.MantaMultipartUploadTuple;
import com.joyent.manta.exception.MantaClientHttpResponseException;
import com.joyent.manta.exception.MantaException;
import com.joyent.manta.exception.MantaIOException;
import com.joyent.manta.exception.MantaMultipartException;
import com.joyent.manta.http.HttpHelper;
import com.joyent.manta.http.MantaHttpHeaders;
import com.joyent.manta.util.MantaUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobsMultipartManager
extends AbstractMultipartManager<JobsMultipartUpload, MantaMultipartUploadPart> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobsMultipartManager.class);
    private static final int MAX_PARTS = 1000;
    static final String MULTIPART_DIRECTORY = "stor/.multipart-6439b444-9041-11e6-9be2-9f622f483d01";
    static final String METADATA_FILE = "metadata.json";
    private static final long DEFAULT_SECONDS_TO_POLL = 5L;
    private static final int NUMBER_OF_TIMES_TO_POLL = 20;
    private final MantaClient mantaClient;
    private final Set<AutoCloseable> danglingStreams;
    private final HttpHelper httpHelper;
    private final String resolvedMultipartUploadDirectory;
    private static final String JOB_NAME_FORMAT = "multipart-%s";
    static final String JOB_ID_METADATA_KEY = "m-multipart-job-id";
    static final String UPLOAD_ID_METADATA_KEY = "m-multipart-upload-id";

    public JobsMultipartManager(MantaClient mantaClient) {
        Set dangling;
        Validate.notNull((Object)mantaClient, (String)"Manta client object must not be null", (Object[])new Object[0]);
        this.mantaClient = mantaClient;
        this.httpHelper = JobsMultipartManager.readFieldFromMantaClient("httpHelper", mantaClient, HttpHelper.class);
        this.resolvedMultipartUploadDirectory = mantaClient.getContext().getMantaHomeDirectory() + "/" + MULTIPART_DIRECTORY;
        this.danglingStreams = dangling = JobsMultipartManager.readFieldFromMantaClient("danglingStreams", mantaClient, Set.class);
    }

    @Override
    public int getMaxParts() {
        return 1000;
    }

    @Override
    public int getMinimumPartSize() {
        return 1;
    }

    @Override
    public Stream<MantaMultipartUpload> listInProgress() throws IOException {
        Stream<MantaObject> multipartDirList;
        CopyOnWriteArrayList exceptions = new CopyOnWriteArrayList();
        try {
            multipartDirList = this.mantaClient.listObjects(this.resolvedMultipartUploadDirectory);
        }
        catch (MantaClientHttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return Stream.empty();
            }
            throw e;
        }
        Stream stream = (Stream)multipartDirList.filter(MantaObject::isDirectory).map(object -> {
            String idString = MantaUtils.lastItemInPath(object.getPath());
            UUID id = UUID.fromString(idString);
            try {
                MultipartMetadata mantaMetadata = this.downloadMultipartMetadata(id);
                JobsMultipartUpload upload = new JobsMultipartUpload(id, mantaMetadata.getPath());
                return upload;
            }
            catch (MantaClientHttpResponseException e) {
                if (e.getStatusCode() == 404) {
                    return null;
                }
                exceptions.add(e);
                return null;
            }
            catch (IOException | RuntimeException e) {
                exceptions.add(e);
                return null;
            }
        }).filter(Objects::nonNull).onClose(multipartDirList::close);
        if (exceptions.isEmpty()) {
            this.danglingStreams.add(stream);
            return stream;
        }
        MantaIOException aggregateException = new MantaIOException("Problem(s) listing multipart uploads in progress");
        MantaUtils.attachExceptionsToContext(aggregateException, exceptions);
        throw aggregateException;
    }

    @Override
    public JobsMultipartUpload initiateUpload(String path) throws IOException {
        return this.initiateUpload(path, new MantaMetadata(), new MantaHttpHeaders());
    }

    @Override
    public JobsMultipartUpload initiateUpload(String path, MantaMetadata mantaMetadata) throws IOException {
        return this.initiateUpload(path, mantaMetadata, new MantaHttpHeaders());
    }

    @Override
    public JobsMultipartUpload initiateUpload(String path, MantaMetadata mantaMetadata, MantaHttpHeaders httpHeaders) throws IOException {
        return this.initiateUpload(path, -1L, mantaMetadata, httpHeaders);
    }

    @Override
    public JobsMultipartUpload initiateUpload(String path, Long contentLength, MantaMetadata mantaMetadata, MantaHttpHeaders httpHeaders) throws IOException {
        MantaMetadata metadata = mantaMetadata == null ? new MantaMetadata() : mantaMetadata;
        UUID uploadId = Generators.timeBasedGenerator().generate();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Creating a new multipart upload [{}] for {}", (Object)uploadId, (Object)path);
        }
        String uploadDir = this.multipartUploadDir(uploadId);
        this.mantaClient.putDirectory(uploadDir, true);
        String metadataPath = uploadDir + METADATA_FILE;
        MultipartMetadata multipartMetadata = new MultipartMetadata().setPath(path).setObjectMetadata(metadata);
        if (httpHeaders != null) {
            multipartMetadata.setContentType(httpHeaders.getContentType());
        }
        byte[] metadataBytes = MantaObjectMapper.INSTANCE.writeValueAsBytes((Object)multipartMetadata);
        LOGGER.debug("Writing metadata to: {}", (Object)metadataPath);
        this.mantaClient.put(metadataPath, metadataBytes);
        return new JobsMultipartUpload(uploadId, path);
    }

    @Override
    MantaMultipartUploadPart uploadPart(JobsMultipartUpload upload, int partNumber, HttpEntity entity, HttpContext context) throws IOException {
        Validate.notNull((Object)upload, (String)"Multipart upload object must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)entity, (String)"Upload entity must not be null", (Object[])new Object[0]);
        String path = this.multipartPath(upload.getId(), partNumber);
        HttpPut put = this.httpHelper.getRequestFactory().put(path);
        put.setEntity(entity);
        int expectedStatusCode = 204;
        CloseableHttpClient httpClient = this.httpHelper.getConnectionContext().getHttpClient();
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)put, context);){
            StatusLine statusLine = response.getStatusLine();
            MantaObjectResponse objectResponse = new MantaObjectResponse(path, new MantaHttpHeaders(response.getAllHeaders()));
            if (statusLine.getStatusCode() != 204) {
                String errorMessage = "Manta server responded with an unexpected response code";
                MantaClientHttpResponseException mchre = new MantaClientHttpResponseException((HttpRequest)put, (HttpResponse)response, path);
                MantaMultipartException e = new MantaMultipartException(errorMessage, mchre);
                HttpHelper.annotateContextedException((ExceptionContext)e, (HttpRequest)put, (HttpResponse)response);
                throw e;
            }
            MantaMultipartUploadPart mantaMultipartUploadPart = new MantaMultipartUploadPart(objectResponse);
            return mantaMultipartUploadPart;
        }
    }

    @Override
    public MantaMultipartUploadPart getPart(JobsMultipartUpload upload, int partNumber) throws IOException {
        Validate.notNull((Object)upload, (String)"Multipart upload object must not be null", (Object[])new Object[0]);
        String path = this.multipartPath(upload.getId(), partNumber);
        MantaObjectResponse response = this.mantaClient.head(path);
        return new MantaMultipartUploadPart(response);
    }

    @Override
    public MantaMultipartStatus getStatus(JobsMultipartUpload upload) throws IOException {
        Validate.notNull((Object)upload, (String)"Multipart upload object must not be null", (Object[])new Object[0]);
        return this.getStatus(upload, null);
    }

    private MantaMultipartStatus getStatus(MantaMultipartUpload upload, UUID jobId) throws IOException {
        MantaObjectResponse response;
        Validate.notNull((Object)upload, (String)"Multipart upload id must not be null", (Object[])new Object[0]);
        String dir = this.multipartUploadDir(upload.getId());
        try {
            response = this.mantaClient.head(dir);
        }
        catch (MantaClientHttpResponseException e) {
            if (e.getStatusCode() == 404) {
                MantaJob job = jobId == null ? this.findJob(upload) : this.mantaClient.getJob(jobId);
                if (job == null) {
                    return MantaMultipartStatus.UNKNOWN;
                }
                if (job.getCancelled() != null && job.getCancelled().booleanValue()) {
                    return MantaMultipartStatus.ABORTED;
                }
                if (job.getState().equals("done")) {
                    return MantaMultipartStatus.COMPLETED;
                }
                if (job.getState().equals("running")) {
                    return MantaMultipartStatus.COMMITTING;
                }
                MantaException mioe = new MantaException("Unexpected job state");
                mioe.setContextValue("job_state", job.getState());
                mioe.setContextValue("job_id", job.getId().toString());
                mioe.setContextValue("multipart_id", upload.getId());
                mioe.setContextValue("multipart_upload_dir", dir);
                throw mioe;
            }
            throw e;
        }
        if (!response.isDirectory()) {
            MantaMultipartException e = new MantaMultipartException("Remote path was a file and not a directory as expected");
            e.setContextValue("multipart_upload_dir", dir);
            throw e;
        }
        MantaJob job = jobId == null ? this.findJob(upload) : this.mantaClient.getJob(jobId);
        if (job == null) {
            return MantaMultipartStatus.CREATED;
        }
        if (job.getCancelled().booleanValue()) {
            return MantaMultipartStatus.ABORTING;
        }
        String state = job.getState();
        if (state.equals("done") || state.equals("running") || state.equals("queued")) {
            return MantaMultipartStatus.COMMITTING;
        }
        return MantaMultipartStatus.UNKNOWN;
    }

    @Override
    public Stream<MantaMultipartUploadPart> listParts(JobsMultipartUpload upload) throws IOException {
        Validate.notNull((Object)upload, (String)"Multipart upload object must not be null", (Object[])new Object[0]);
        String dir = this.multipartUploadDir(upload.getId());
        Stream<MantaMultipartUploadPart> stream = this.mantaClient.listObjects(dir).filter(value -> !Paths.get(value.getPath(), new String[0]).getFileName().toString().equals(METADATA_FILE)).map(MantaMultipartUploadPart::new);
        this.danglingStreams.add(stream);
        return stream;
    }

    @Override
    public void abort(JobsMultipartUpload upload) throws IOException {
        Validate.notNull((Object)upload, (String)"Multipart upload object must not be null", (Object[])new Object[0]);
        String dir = this.multipartUploadDir(upload.getId());
        MantaJob job = this.findJob(upload);
        LOGGER.debug("Aborting multipart upload [{}]", (Object)upload.getId());
        if (job != null && (job.getState().equals("running") || job.getState().equals("queued"))) {
            LOGGER.debug("Aborting multipart upload [{}] backing job [{}]", (Object)upload.getId(), (Object)job);
            this.mantaClient.cancelJob(job.getId());
        }
        LOGGER.debug("Deleting multipart upload data from: {}", (Object)dir);
        this.mantaClient.deleteRecursive(dir);
    }

    @Override
    public void complete(JobsMultipartUpload upload, Iterable<? extends MantaMultipartUploadTuple> parts) throws IOException {
        Validate.notNull((Object)upload, (String)"Multipart upload object must not be null", (Object[])new Object[0]);
        try (Stream<? extends MantaMultipartUploadTuple> stream = StreamSupport.stream(parts.spliterator(), false);){
            this.complete(upload, stream);
        }
    }

    @Override
    public void complete(JobsMultipartUpload upload, Stream<? extends MantaMultipartUploadTuple> partsStream) throws IOException {
        MantaMetadata objectMetadata;
        Validate.notNull((Object)upload, (String)"Multipart upload object must not be null", (Object[])new Object[0]);
        LOGGER.debug("Completing multipart upload [{}]", (Object)upload.getId());
        String uploadDir = this.multipartUploadDir(upload.getId());
        MultipartMetadata metadata = this.downloadMultipartMetadata(upload.getId());
        HashMap listing = new HashMap();
        try (Stream<MantaMultipartUploadPart> listStream = this.listParts(upload).limit(this.getMaxParts());){
            listStream.forEach(p -> listing.put(p.getEtag(), p));
        }
        String path = metadata.getPath();
        StringBuilder jobExecText = new StringBuilder("set -o pipefail; mget -q ");
        ArrayList missingTuples = new ArrayList();
        AtomicInteger count = new AtomicInteger(0);
        try (Stream<? extends MantaMultipartUploadTuple> distinct = partsStream.sorted().distinct();){
            distinct.forEach(part -> {
                int i = count.incrementAndGet();
                if (i > this.getMaxParts()) {
                    String msg = String.format("Too many multipart parts specified [%d]. The maximum number of parts is %d", this.getMaxParts(), count.get());
                    throw new IllegalArgumentException(msg);
                }
                if (i != part.getPartNumber()) {
                    missingTuples.add(new MantaMultipartUploadTuple(i, "N/A"));
                } else {
                    MantaMultipartUploadPart o = (MantaMultipartUploadPart)listing.get(part.getEtag());
                    if (o != null) {
                        jobExecText.append(o.getObjectPath()).append(" ");
                    } else {
                        missingTuples.add(part);
                    }
                }
            });
        }
        if (!missingTuples.isEmpty()) {
            MantaMultipartException e = new MantaMultipartException("Multipart part(s) specified couldn't be found");
            int missingCount = 0;
            for (MantaMultipartUploadTuple missingPart : missingTuples) {
                String key = String.format("missing_part_%d", ++missingCount);
                e.setContextValue(key, missingPart.toString());
            }
            throw e;
        }
        String headerFormat = "\"%s: %s\" ";
        jobExecText.append("| mput ").append("-H ").append(String.format("\"%s: %s\" ", UPLOAD_ID_METADATA_KEY, upload.getId())).append("-H ").append(String.format("\"%s: %s\" ", JOB_ID_METADATA_KEY, "$MANTA_JOB_ID")).append("-q ");
        if (metadata.getContentType() != null) {
            jobExecText.append("-H 'Content-Type: ").append(metadata.getContentType()).append("' ");
        }
        if ((objectMetadata = metadata.getObjectMetadata()) != null) {
            Set<Map.Entry<String, String>> entries = objectMetadata.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                jobExecText.append("-H '").append(entry.getKey()).append(": ").append(entry.getValue()).append("' ");
            }
        }
        jobExecText.append(path);
        MantaJobPhase concatPhase = new MantaJobPhase().setType("reduce").setExec(jobExecText.toString());
        MantaJobPhase cleanupPhase = new MantaJobPhase().setType("reduce").setExec("mrm -r " + uploadDir);
        MantaJobBuilder.Run run = this.mantaClient.jobBuilder().newJob(String.format(JOB_NAME_FORMAT, upload.getId())).addPhase(concatPhase).addPhase(cleanupPhase).run();
        this.writeJobIdToMetadata(upload.getId(), run.getId());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Created job for concatenating parts: {}", (Object)run.getId());
        }
    }

    protected MultipartMetadata downloadMultipartMetadata(UUID id) throws IOException {
        String uploadDir = this.multipartUploadDir(id);
        String metadataPath = uploadDir + METADATA_FILE;
        LOGGER.debug("Reading metadata from: {}", (Object)metadataPath);
        try (MantaObjectInputStream in = this.mantaClient.getAsInputStream(metadataPath);){
            MultipartMetadata multipartMetadata = (MultipartMetadata)MantaObjectMapper.INSTANCE.readValue((InputStream)in, MultipartMetadata.class);
            return multipartMetadata;
        }
    }

    protected void writeJobIdToMetadata(UUID uploadId, UUID jobId) throws IOException {
        Validate.notNull((Object)uploadId, (String)"Multipart upload id must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)jobId, (String)"Job id must not be null", (Object[])new Object[0]);
        String uploadDir = this.multipartUploadDir(uploadId);
        String metadataPath = uploadDir + METADATA_FILE;
        LOGGER.debug("Writing job id [{}] to: {}", (Object)jobId, (Object)metadataPath);
        MantaMetadata metadata = new MantaMetadata();
        metadata.put(JOB_ID_METADATA_KEY, jobId.toString());
        this.mantaClient.putMetadata(metadataPath, metadata);
    }

    protected UUID getJobIdFromMetadata(UUID uploadId) throws IOException {
        Validate.notNull((Object)uploadId, (String)"Multipart upload id must not be null", (Object[])new Object[0]);
        String uploadDir = this.multipartUploadDir(uploadId);
        String metadataPath = uploadDir + METADATA_FILE;
        try {
            MantaObjectResponse response = this.mantaClient.head(metadataPath);
            String uuidAsString = response.getMetadata().get(JOB_ID_METADATA_KEY);
            if (uuidAsString == null) {
                return null;
            }
            return UUID.fromString(uuidAsString);
        }
        catch (MantaClientHttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    public <R> R waitForCompletion(MantaMultipartUpload upload, Function<UUID, R> executeWhenTimesToPollExceeded) throws IOException {
        Validate.notNull((Object)upload, (String)"Multipart upload object must not be null", (Object[])new Object[0]);
        return this.waitForCompletion(upload, Duration.ofSeconds(5L), 20, executeWhenTimesToPollExceeded);
    }

    public <R> R waitForCompletion(MantaMultipartUpload upload, Duration pingInterval, int timesToPoll, Function<UUID, R> executeWhenTimesToPollExceeded) throws IOException {
        int timesPolled;
        if (timesToPoll <= 0) {
            String msg = String.format("times to poll should be set to a value greater than 1. Actual value: %d", timesToPoll);
            throw new IllegalArgumentException(msg);
        }
        String dir = this.multipartUploadDir(upload.getId());
        MantaJob job = this.findJob(upload);
        if (job == null) {
            String msg = "Unable for find job associated with multipart upload. Was complete() run for upload or was it run so long ago that we no longer have a record for it?";
            MantaMultipartException e = new MantaMultipartException(msg);
            e.setContextValue("upload_id", upload.getId().toString());
            e.setContextValue("upload_directory", dir);
            e.setContextValue("job_id", job.getId().toString());
            throw e;
        }
        long waitMillis = pingInterval.toMillis();
        for (timesPolled = 0; timesPolled < timesToPoll; ++timesPolled) {
            try {
                MantaMultipartStatus status = this.getStatus(upload, job.getId());
                if (status.equals(MantaMultipartStatus.COMPLETED)) {
                    return null;
                }
                if (status.equals(MantaMultipartStatus.ABORTED)) {
                    String msg = "Manta job backing multipart upload was aborted. This upload was unable to be completed.";
                    MantaMultipartException e = new MantaMultipartException(msg);
                    e.setContextValue("upload_id", upload.getId().toString());
                    e.setContextValue("upload_directory", dir);
                    e.setContextValue("job_id", job.getId().toString());
                    throw e;
                }
                if (status.equals(MantaMultipartStatus.UNKNOWN)) {
                    String msg = "Manta job backing multipart upload was is in a unknown state. Typically this means that we are unable to get the status of the job backing the multipart upload.";
                    MantaMultipartException e = new MantaMultipartException(msg);
                    e.setContextValue("upload_id", upload.getId().toString());
                    e.setContextValue("upload_directory", dir);
                    e.setContextValue("job_id", job.getId().toString());
                    throw e;
                }
                if (timesPolled >= timesToPoll + 1) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Waiting for [{}] ms for upload [{}] to complete (try {} of {})", new Object[]{waitMillis, upload.getId(), timesPolled + 1, timesToPoll});
                }
                Thread.sleep(waitMillis);
                continue;
            }
            catch (InterruptedException e) {
                return executeWhenTimesToPollExceeded.apply(upload.getId());
            }
        }
        if (timesPolled >= timesToPoll) {
            return executeWhenTimesToPollExceeded.apply(upload.getId());
        }
        return null;
    }

    String multipartPath(UUID id, int partNumber) {
        this.validatePartNumber(partNumber);
        String dir = this.multipartUploadDir(id);
        return String.format("%s%d", dir, partNumber);
    }

    String multipartUploadDir(UUID id) {
        Validate.notNull((Object)id, (String)"Multipart transaction id must not be null", (Object[])new Object[0]);
        return this.resolvedMultipartUploadDirectory + "/" + id.toString() + "/";
    }

    MantaJob findJob(MantaMultipartUpload upload) throws IOException {
        UUID jobId = this.getJobIdFromMetadata(upload.getId());
        if (jobId == null) {
            LOGGER.debug("Unable to get job id from metadata directory. Now trying job listing.");
            try (Stream<MantaJob> jobs = this.mantaClient.getJobsByName(String.format(JOB_NAME_FORMAT, upload.getId()));){
                MantaJob mantaJob = jobs.findFirst().orElse(null);
                return mantaJob;
            }
        }
        return this.mantaClient.getJob(jobId);
    }

    @JsonInclude
    static class MultipartMetadata
    implements Serializable {
        private static final long serialVersionUID = -4410867990710890357L;
        @JsonProperty
        private String path;
        @JsonProperty(value="object_metadata")
        private HashMap<String, String> objectMetadata;
        @JsonProperty(value="content_type")
        private String contentType;

        MultipartMetadata() {
        }

        String getPath() {
            return this.path;
        }

        MultipartMetadata setPath(String path) {
            this.path = path;
            return this;
        }

        MantaMetadata getObjectMetadata() {
            if (this.objectMetadata == null) {
                return null;
            }
            return new MantaMetadata(this.objectMetadata);
        }

        MultipartMetadata setObjectMetadata(MantaMetadata objectMetadata) {
            this.objectMetadata = objectMetadata != null ? new HashMap<String, String>(objectMetadata) : null;
            return this;
        }

        String getContentType() {
            return this.contentType;
        }

        MultipartMetadata setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }
    }
}

