/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.onedrive.OneDriveContainerListService;
import ch.cyberduck.core.onedrive.OneDriveItemListService;
import ch.cyberduck.core.onedrive.OneDriveSession;
import ch.cyberduck.core.onedrive.features.OneDriveFileIdProvider;

public class OneDriveListService
implements ListService {
    private final OneDriveSession session;
    private final OneDriveFileIdProvider fileIdProvider;

    public OneDriveListService(OneDriveSession session, OneDriveFileIdProvider fileIdProvider) {
        this.session = session;
        this.fileIdProvider = fileIdProvider;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        if (directory.isRoot()) {
            return new OneDriveContainerListService(this.session).list(directory, listener);
        }
        return new OneDriveItemListService(this.session).list(directory, listener);
    }

    public ListService withCache(Cache<Path> cache) {
        this.fileIdProvider.withCache(cache);
        return this;
    }
}

