/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.VersioningConfiguration;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.S3BucketVersioningStatus;
import org.jets3t.service.model.S3Object;

public class S3VersioningFeature
implements Versioning {
    private static final Logger log = Logger.getLogger(S3VersioningFeature.class);
    private final S3Session session;
    private final PathContainerService containerService = new S3PathContainerService();
    private final S3AccessControlListFeature accessControlListFeature;
    private Map<Path, VersioningConfiguration> cache = Collections.synchronizedMap(new LRUMap(10));

    public S3VersioningFeature(S3Session session, S3AccessControlListFeature accessControlListFeature) {
        this.session = session;
        this.accessControlListFeature = accessControlListFeature;
    }

    public S3VersioningFeature withCache(Map<Path, VersioningConfiguration> cache) {
        this.cache = cache;
        return this;
    }

    public void setConfiguration(Path file, PasswordCallback prompt, VersioningConfiguration configuration) throws BackgroundException {
        Path container = this.containerService.getContainer(file);
        try {
            VersioningConfiguration current = this.getConfiguration(container);
            if (current.isMultifactor()) {
                Credentials factor = this.getToken("", prompt);
                if (configuration.isEnabled()) {
                    if (current.isEnabled()) {
                        log.debug((Object)String.format("Versioning already enabled for bucket %s", container));
                    } else {
                        log.debug((Object)String.format("Enable bucket versioning with MFA %s for %s", factor.getUsername(), container));
                        ((RequestEntityRestStorageService)((Object)this.session.getClient())).enableBucketVersioningWithMFA(container.getName(), factor.getUsername(), factor.getPassword());
                    }
                } else {
                    log.debug((Object)String.format("Suspend bucket versioning with MFA %s for %s", factor.getUsername(), container));
                    ((RequestEntityRestStorageService)((Object)this.session.getClient())).suspendBucketVersioningWithMFA(container.getName(), factor.getUsername(), factor.getPassword());
                }
                if (configuration.isEnabled() && !configuration.isMultifactor()) {
                    log.debug((Object)String.format("Disable MFA %s for %s", factor.getUsername(), container));
                    Credentials factor2 = this.getToken("", prompt);
                    ((RequestEntityRestStorageService)((Object)this.session.getClient())).disableMFAForVersionedBucket(container.getName(), factor2.getUsername(), factor2.getPassword());
                }
            } else if (configuration.isEnabled()) {
                if (configuration.isMultifactor()) {
                    Credentials factor = this.getToken("", prompt);
                    log.debug((Object)String.format("Enable bucket versioning with MFA %s for %s", factor.getUsername(), container));
                    ((RequestEntityRestStorageService)((Object)this.session.getClient())).enableBucketVersioningWithMFA(container.getName(), factor.getUsername(), factor.getPassword());
                } else if (current.isEnabled()) {
                    log.debug((Object)String.format("Versioning already enabled for bucket %s", container));
                } else {
                    log.debug((Object)String.format("Enable bucket versioning for %s", container));
                    ((RequestEntityRestStorageService)((Object)this.session.getClient())).enableBucketVersioning(container.getName());
                }
            } else {
                log.debug((Object)String.format("Susped bucket versioning for %s", container));
                ((RequestEntityRestStorageService)((Object)this.session.getClient())).suspendBucketVersioning(container.getName());
            }
            this.cache.remove(container);
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Failure to write attributes of {0}", e);
        }
    }

    public VersioningConfiguration getConfiguration(Path file) throws BackgroundException {
        Path container = this.containerService.getContainer(file);
        if (container.isRoot()) {
            return VersioningConfiguration.empty();
        }
        if (this.cache.containsKey(container)) {
            return this.cache.get(container);
        }
        try {
            S3BucketVersioningStatus status = ((RequestEntityRestStorageService)((Object)this.session.getClient())).getBucketVersioningStatus(container.getName());
            VersioningConfiguration configuration = new VersioningConfiguration(status.isVersioningEnabled(), status.isMultiFactorAuthDeleteRequired());
            this.cache.put(container, configuration);
            return configuration;
        }
        catch (ServiceException e) {
            try {
                throw new S3ExceptionMappingService().map("Cannot read bucket versioning status", e);
            }
            catch (AccessDeniedException l) {
                log.warn((Object)String.format("Missing permission to read versioning configuration for %s %s", container, e.getMessage()));
                return VersioningConfiguration.empty();
            }
            catch (InteroperabilityException i) {
                log.warn((Object)String.format("Not supported to read versioning configuration for %s %s", container, e.getMessage()));
                return VersioningConfiguration.empty();
            }
        }
    }

    public void revert(Path file) throws BackgroundException {
        if (file.isFile()) {
            try {
                S3Object destination = new S3Object(this.containerService.getKey(file));
                destination.setStorageClass(file.attributes().getStorageClass());
                Encryption.Algorithm encryption = file.attributes().getEncryption();
                destination.setServerSideEncryptionAlgorithm(encryption.algorithm);
                destination.setServerSideEncryptionKmsKeyId(encryption.key);
                Acl acl = Acl.EMPTY;
                try {
                    acl = this.accessControlListFeature.getPermission(file);
                }
                catch (AccessDeniedException | InteroperabilityException e) {
                    log.warn((Object)String.format("Ignore failure %s", e.getDetail()));
                }
                destination.setAcl(this.accessControlListFeature.convert(acl));
                ((RequestEntityRestStorageService)((Object)this.session.getClient())).copyVersionedObject(file.attributes().getVersionId(), this.containerService.getContainer(file).getName(), this.containerService.getKey(file), this.containerService.getContainer(file).getName(), destination, false);
                if (file.getParent().attributes().getCustom().containsKey("delete_marker")) {
                    ((RequestEntityRestStorageService)((Object)this.session.getClient())).deleteVersionedObject(file.getParent().attributes().getVersionId(), this.containerService.getContainer(file).getName(), this.containerService.getKey(file.getParent()));
                }
            }
            catch (ServiceException e) {
                throw new S3ExceptionMappingService().map("Cannot revert file", e, file);
            }
        }
    }

    public boolean isRevertable(Path file) {
        return file.attributes().isDuplicate();
    }

    public Credentials getToken(String mfaSerial, PasswordCallback callback) throws ConnectionCanceledException {
        return callback.prompt(this.session.getHost(), LocaleFactory.localizedString((String)"Provide additional login credentials", (String)"Credentials"), String.format("%s %s", LocaleFactory.localizedString((String)"Multi-Factor Authentication", (String)"S3"), mfaSerial), new LoginOptions(this.session.getHost().getProtocol()).password(true).passwordPlaceholder(LocaleFactory.localizedString((String)"MFA Authentication Code", (String)"S3")).keychain(false));
    }
}

