/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.VersioningConfiguration;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.StorageObjectsChunk;
import org.jets3t.service.VersionOrDeleteMarkersChunk;
import org.jets3t.service.model.BaseVersionOrDeleteMarker;
import org.jets3t.service.model.S3Version;

public class S3VersionedObjectListService
implements ListService {
    private static final Logger log = Logger.getLogger(S3VersionedObjectListService.class);
    public static final String KEY_DELETE_MARKER = "delete_marker";
    private final Preferences preferences = PreferencesFactory.get();
    private final PathContainerService containerService = new S3PathContainerService();
    private final S3Session session;

    public S3VersionedObjectListService(S3Session session) {
        this.session = session;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        String prefix = this.createPrefix(directory);
        Path bucket = this.containerService.getContainer(directory);
        VersioningConfiguration versioning = null != this.session.getFeature(Versioning.class) ? ((Versioning)this.session.getFeature(Versioning.class)).getConfiguration(bucket) : VersioningConfiguration.empty();
        AttributedList children = new AttributedList();
        try {
            String priorLastKey = null;
            String priorLastVersionId = null;
            long revision = 0L;
            String lastKey = null;
            do {
                String[] prefixes;
                VersionOrDeleteMarkersChunk chunk = ((RequestEntityRestStorageService)((Object)this.session.getClient())).listVersionedObjectsChunked(bucket.getName(), prefix, String.valueOf('/'), this.preferences.getInteger("s3.listing.chunksize"), priorLastKey, priorLastVersionId, true);
                for (BaseVersionOrDeleteMarker marker : chunk.getItems()) {
                    String key = PathNormalizer.normalize((String)marker.getKey());
                    if (String.valueOf('/').equals(key)) {
                        log.warn((Object)String.format("Skipping prefix %s", key));
                        continue;
                    }
                    if (new Path(bucket, key, EnumSet.of(AbstractPath.Type.directory)).equals((Object)directory)) continue;
                    PathAttributes attributes = new PathAttributes();
                    if (versioning.isEnabled()) {
                        attributes.setVersionId(marker.getVersionId());
                    }
                    if (!StringUtils.equals(lastKey, (CharSequence)key)) {
                        revision = 0L;
                    }
                    attributes.setRevision(Long.valueOf(++revision));
                    attributes.setDuplicate(marker.isDeleteMarker() && marker.isLatest() || !marker.isLatest());
                    if (marker.isDeleteMarker()) {
                        attributes.setCustom(Collections.singletonMap(KEY_DELETE_MARKER, Boolean.TRUE.toString()));
                    }
                    attributes.setModificationDate(marker.getLastModified().getTime());
                    attributes.setRegion(bucket.attributes().getRegion());
                    if (marker instanceof S3Version) {
                        S3Version object = (S3Version)marker;
                        attributes.setSize(object.getSize());
                        if (StringUtils.isNotBlank((CharSequence)object.getEtag())) {
                            attributes.setETag(object.getEtag());
                        }
                        if (StringUtils.isNotBlank((CharSequence)object.getStorageClass())) {
                            attributes.setStorageClass(object.getStorageClass());
                        }
                    }
                    Path f = new Path(directory, PathNormalizer.name((String)key), EnumSet.of(AbstractPath.Type.file), attributes);
                    children.add((Referenceable)f);
                    lastKey = key;
                }
                for (String common : prefixes = chunk.getCommonPrefixes()) {
                    VersionOrDeleteMarkersChunk versions;
                    if (String.valueOf('/').equals(common)) {
                        log.warn((Object)String.format("Skipping prefix %s", common));
                        continue;
                    }
                    String key = PathNormalizer.normalize((String)common);
                    if (new Path(bucket, key, EnumSet.of(AbstractPath.Type.directory)).equals((Object)directory)) continue;
                    PathAttributes attributes = new PathAttributes();
                    attributes.setRegion(bucket.attributes().getRegion());
                    if (versioning.isEnabled() && (versions = ((RequestEntityRestStorageService)((Object)this.session.getClient())).listVersionedObjectsChunked(bucket.getName(), common, String.valueOf('/'), 1L, null, null, false)).getItems().length == 1) {
                        BaseVersionOrDeleteMarker version = versions.getItems()[0];
                        if (version.getKey().equals(common)) {
                            attributes.setVersionId(version.getVersionId());
                            if (version.isDeleteMarker()) {
                                attributes.setCustom((Map)ImmutableMap.of((Object)KEY_DELETE_MARKER, (Object)Boolean.TRUE.toString()));
                                attributes.setDuplicate(true);
                            }
                        } else {
                            StorageObjectsChunk unversioned = ((RequestEntityRestStorageService)((Object)this.session.getClient())).listObjectsChunked(bucket.getName(), common, "", 1L, null, false);
                            if (unversioned.getObjects().length == 0) {
                                attributes.setDuplicate(true);
                            }
                        }
                    }
                    Path file = new Path(String.format("%s%s", bucket.getAbsolute(), key), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.placeholder), attributes);
                    children.add((Referenceable)file);
                }
                priorLastKey = chunk.getNextKeyMarker();
                priorLastVersionId = chunk.getNextVersionIdMarker();
                listener.chunk(directory, children);
            } while (priorLastKey != null);
            return children;
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
    }

    public ListService withCache(Cache<Path> cache) {
        return this;
    }

    protected String createPrefix(Path directory) {
        String prefix = "";
        if (!this.containerService.isContainer(directory) && !(prefix = this.containerService.getKey(directory)).endsWith(String.valueOf('/'))) {
            prefix = prefix + '/';
        }
        return prefix;
    }
}

