/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.analytics.AnalyticsProvider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.identity.IdentityConfiguration;
import ch.cyberduck.core.worker.Worker;

public class WriteIdentityWorker
extends Worker<Boolean> {
    private final LoginCallback prompt;
    private final Boolean enabled;
    private final String policy;

    public WriteIdentityWorker(LoginCallback prompt, Boolean enabled, String policy) {
        this.prompt = prompt;
        this.enabled = enabled;
        this.policy = policy;
    }

    @Override
    public Boolean run(Session<?> session) throws BackgroundException {
        IdentityConfiguration iam = session.getFeature(IdentityConfiguration.class);
        AnalyticsProvider analytics = session.getFeature(AnalyticsProvider.class);
        if (this.enabled.booleanValue()) {
            iam.create(analytics.getName(), this.policy, this.prompt);
        } else {
            iam.delete(analytics.getName(), this.prompt);
        }
        return true;
    }

    @Override
    public Boolean initialize() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteIdentityWorker that = (WriteIdentityWorker)o;
        return !(this.policy != null ? !this.policy.equals(that.policy) : that.policy != null);
    }

    public int hashCode() {
        return this.policy != null ? this.policy.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WriteIdentityWorker{");
        sb.append("policy=").append(this.policy);
        sb.append('}');
        return sb.toString();
    }
}

