/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.io;

import ch.cyberduck.core.io.Buffer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.ProxyOutputStream;

public class BufferOutputStream
extends ProxyOutputStream {
    private static final Logger log = Logger.getLogger(BufferOutputStream.class.getName());
    private final Buffer buffer;
    private Long offset;

    public BufferOutputStream(Buffer buffer) {
        this((OutputStream)new NullOutputStream(), buffer, 0L);
    }

    public BufferOutputStream(Buffer buffer, Long offset) {
        this((OutputStream)new NullOutputStream(), buffer, offset);
    }

    public BufferOutputStream(OutputStream proxy, Buffer buffer, Long offset) {
        super(proxy);
        this.buffer = buffer;
        this.offset = offset;
    }

    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    public void write(byte[] bytes, int off, int len) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("Buffer %d bytes at offset %d", len, this.offset));
        }
        byte[] chunk = new byte[len];
        System.arraycopy(bytes, off, chunk, 0, len);
        this.buffer.write(chunk, this.offset);
        super.write(bytes, off, len);
    }

    protected void afterWrite(int n) throws IOException {
        this.offset = this.offset + (long)n;
    }
}

