/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.editor;

import ch.cyberduck.core.Factory;
import ch.cyberduck.core.FactoryException;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.editor.Editor;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.ApplicationFinder;
import ch.cyberduck.core.local.ApplicationFinderFactory;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class EditorFactory
extends Factory<EditorFactory> {
    private static final Logger log = Logger.getLogger(EditorFactory.class);
    private final Preferences preferences = PreferencesFactory.get();
    private final ApplicationFinder applicationFinder;
    private static EditorFactory factory;

    public EditorFactory() {
        this(ApplicationFinderFactory.get());
    }

    public EditorFactory(ApplicationFinder applicationFinder) {
        this.applicationFinder = applicationFinder;
    }

    public static synchronized EditorFactory instance() {
        if (null == factory) {
            try {
                String clazz = PreferencesFactory.get().getProperty("factory.editorfactory.class");
                if (null == clazz) {
                    throw new FactoryException();
                }
                Class<?> name = Class.forName(clazz);
                factory = (EditorFactory)name.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new FactoryException(e.getMessage(), e);
            }
        }
        return factory;
    }

    protected abstract List<Application> getConfigured();

    public List<Application> getEditors() {
        ArrayList<Application> editors = new ArrayList<Application>(this.getConfigured());
        Application defaultEditor = this.getDefaultEditor();
        if (this.applicationFinder.isInstalled(defaultEditor) && !editors.contains(defaultEditor)) {
            editors.add(defaultEditor);
        }
        return editors;
    }

    public Editor create(ProgressListener listener, SessionPool session, Path path) {
        return this.create(listener, session, this.getEditor(path.getName()), path);
    }

    public abstract Editor create(ProgressListener var1, SessionPool var2, Application var3, Path var4);

    public Application getDefaultEditor() {
        Application application = this.applicationFinder.getDescription(this.preferences.getProperty("editor.bundleIdentifier"));
        if (this.applicationFinder.isInstalled(application)) {
            return application;
        }
        return Application.notfound;
    }

    public Application getEditor(String filename) {
        Application application = this.getDefaultEditor();
        if (this.preferences.getBoolean("editor.alwaysUseDefault")) {
            return application;
        }
        Application editor = this.applicationFinder.find(filename);
        if (!this.applicationFinder.isInstalled(editor)) {
            log.warn((Object)String.format("No editor found for %s", filename));
            return application;
        }
        return editor;
    }

    public List<Application> getEditors(String filename) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Find installed editors for file %s", filename));
        }
        ArrayList<Application> editors = new ArrayList<Application>(this.applicationFinder.findAll(filename));
        Application defaultEditor = this.getDefaultEditor();
        if (this.applicationFinder.isInstalled(defaultEditor) && !editors.contains(defaultEditor)) {
            editors.add(defaultEditor);
        }
        return editors;
    }
}

