/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpUploadFeature;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.io.StreamProgress;
import ch.cyberduck.core.openstack.SwiftExceptionMappingService;
import ch.cyberduck.core.openstack.SwiftObjectListService;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSegmentService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.DefaultRetryCallable;
import ch.cyberduck.core.threading.DefaultThreadPool;
import ch.cyberduck.core.threading.ThreadPool;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.DefaultExceptionMappingService;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.model.StorageObject;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class SwiftLargeObjectUploadFeature
extends HttpUploadFeature<StorageObject, MessageDigest> {
    private static final Logger log = Logger.getLogger(SwiftLargeObjectUploadFeature.class);
    private final SwiftSession session;
    private final PathContainerService containerService = new PathContainerService();
    private final SwiftSegmentService segmentService;
    private final SwiftObjectListService listService;
    private final SwiftRegionService regionService;
    private final Long segmentSize;
    private final Integer concurrency;
    private Write<StorageObject> writer;

    public SwiftLargeObjectUploadFeature(SwiftSession session, SwiftRegionService regionService, Write<StorageObject> writer, Long segmentSize, Integer concurrency) {
        this(session, regionService, new SwiftObjectListService(session, regionService), new SwiftSegmentService(session, regionService), writer, segmentSize, concurrency);
    }

    public SwiftLargeObjectUploadFeature(SwiftSession session, SwiftRegionService regionService, SwiftObjectListService listService, SwiftSegmentService segmentService, Write<StorageObject> writer, Long segmentSize, Integer concurrency) {
        super(writer);
        this.session = session;
        this.regionService = regionService;
        this.writer = writer;
        this.segmentSize = segmentSize;
        this.segmentService = segmentService;
        this.listService = listService;
        this.concurrency = concurrency;
    }

    public StorageObject upload(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        DefaultThreadPool pool = new DefaultThreadPool("multipart", this.concurrency.intValue());
        ArrayList existingSegments = new ArrayList();
        if (status.isAppend() || status.isRetry()) {
            existingSegments.addAll(this.listService.list(this.segmentService.getSegmentsDirectory(file, status.getOffset() + status.getLength()), (ListProgressListener)new DisabledListProgressListener()).toList());
        }
        ArrayList<StorageObject> completed = new ArrayList<StorageObject>();
        ArrayList<Future<StorageObject>> segments = new ArrayList<Future<StorageObject>>();
        long remaining = status.getLength();
        long offset = 0L;
        int segmentNumber = 1;
        while (remaining > 0L) {
            Long l = Math.min(this.segmentSize, remaining);
            Path segment = this.segmentService.getSegment(file, status.getOffset() + status.getLength(), segmentNumber);
            if (existingSegments.contains(segment)) {
                Path existingSegment = (Path)existingSegments.get(existingSegments.indexOf(segment));
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Skip segment %s", existingSegment));
                }
                StorageObject stored = new StorageObject(this.containerService.getKey(segment));
                if (HashAlgorithm.md5.equals((Object)existingSegment.attributes().getChecksum().algorithm)) {
                    stored.setMd5sum(existingSegment.attributes().getChecksum().hash);
                }
                stored.setSize(Long.valueOf(existingSegment.attributes().getSize()));
                offset += existingSegment.attributes().getSize();
                completed.add(stored);
            } else {
                segments.add(this.submit((ThreadPool)pool, segment, local, throttle, listener, status, offset, l, callback));
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Segment %s submitted with size %d and offset %d", segment, l, offset));
                }
                remaining -= l.longValue();
                offset += l.longValue();
            }
            ++segmentNumber;
        }
        try {
            for (Future future : segments) {
                completed.add((StorageObject)future.get());
            }
        }
        catch (InterruptedException e) {
            log.error((Object)"Part upload failed with interrupt failure");
            status.setCanceled();
            throw new ConnectionCanceledException((Throwable)e);
        }
        catch (ExecutionException e) {
            log.warn((Object)String.format("Part upload failed with execution failure %s", e.getMessage()));
            if (e.getCause() instanceof BackgroundException) {
                throw (BackgroundException)e.getCause();
            }
            throw new DefaultExceptionMappingService().map(e.getCause());
        }
        finally {
            pool.shutdown(false);
        }
        status.setComplete();
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Finished large file upload %s with %d parts", file, completed.size()));
        }
        try {
            String manifest = this.segmentService.manifest(this.containerService.getContainer(file).getName(), completed);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Creating SLO manifest %s for %s", manifest, file));
            }
            StorageObject storageObject = new StorageObject(this.containerService.getKey(file));
            String checksum = ((Client)this.session.getClient()).createSLOManifestObject(this.regionService.lookup(this.containerService.getContainer(file)), this.containerService.getContainer(file).getName(), status.getMime(), this.containerService.getKey(file), manifest, Collections.emptyMap());
            storageObject.setMd5sum(checksum);
            return storageObject;
        }
        catch (GenericException e) {
            throw new SwiftExceptionMappingService().map("Upload {0} failed", e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
        }
    }

    private Future<StorageObject> submit(ThreadPool pool, final Path segment, final Local local, final BandwidthThrottle throttle, final StreamListener listener, final TransferStatus overall, final Long offset, final Long length, final ConnectionCallback callback) {
        return pool.execute((Callable)new DefaultRetryCallable((BackgroundExceptionCallable)new BackgroundExceptionCallable<StorageObject>(){

            public StorageObject call() throws BackgroundException {
                if (overall.isCanceled()) {
                    throw new ConnectionCanceledException();
                }
                final TransferStatus status = new TransferStatus().length(length.longValue()).skip(offset.longValue());
                status.setHeader(overall.getHeader());
                status.setNonces(overall.getNonces());
                status.setChecksum(SwiftLargeObjectUploadFeature.this.writer.checksum(segment).compute(local.getInputStream(), status));
                status.setSegment(true);
                return (StorageObject)SwiftLargeObjectUploadFeature.super.upload(segment, local, throttle, listener, status, (StreamCancelation)overall, new StreamProgress(){

                    public void progress(long bytes) {
                        status.progress(bytes);
                        overall.progress(bytes);
                    }

                    public void setComplete() {
                        status.setComplete();
                    }
                }, callback);
            }
        }, overall));
    }

    public Upload<StorageObject> withWriter(Write<StorageObject> writer) {
        this.writer = writer;
        return super.withWriter(writer);
    }
}

