/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.nio;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.nio.LocalAttributesFinderFeature;
import ch.cyberduck.core.nio.LocalExceptionMappingService;
import ch.cyberduck.core.nio.LocalSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class LocalCopyFeature
implements Copy {
    private final LocalSession session;

    public LocalCopyFeature(LocalSession session) {
        this.session = session;
    }

    public Path copy(Path source, Path target, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            Files.copy(this.session.toPath(source), this.session.toPath(target), StandardCopyOption.REPLACE_EXISTING);
            return new Path(target.getParent(), target.getName(), target.getType(), new LocalAttributesFinderFeature(this.session).find(target));
        }
        catch (IOException e) {
            throw new LocalExceptionMappingService().map("Cannot copy {0}", e, source);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }

    public boolean isSupported(Path source, Path target) {
        return true;
    }
}

