/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.date.InvalidDateException;
import ch.cyberduck.core.date.RFC1123DateFormatter;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.dav.DAVExceptionMappingService;
import ch.cyberduck.core.dav.DAVPathEncoder;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.dav.DAVTimestampFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.http.HttpExceptionMappingService;
import ch.cyberduck.core.io.Checksum;
import com.github.sardine.DavResource;
import com.github.sardine.impl.SardineException;
import com.github.sardine.impl.handler.HeadersResponseHandler;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.log4j.Logger;

public class DAVAttributesFinderFeature
implements AttributesFinder {
    private static final Logger log = Logger.getLogger(DAVAttributesFinderFeature.class);
    private final DAVSession session;
    private final RFC1123DateFormatter dateParser = new RFC1123DateFormatter();

    public DAVAttributesFinderFeature(DAVSession session) {
        this.session = session;
    }

    public PathAttributes find(Path file) throws BackgroundException {
        if (file.isRoot()) {
            return PathAttributes.EMPTY;
        }
        try {
            try {
                List status = ((DAVClient)((Object)this.session.getClient())).list(new DAVPathEncoder().encode(file), 1, Stream.of(DAVTimestampFeature.LAST_MODIFIED_CUSTOM_NAMESPACE, DAVTimestampFeature.LAST_MODIFIED_SERVER_CUSTOM_NAMESPACE).collect(Collectors.toSet()));
                Iterator iterator = status.iterator();
                if (iterator.hasNext()) {
                    DavResource resource = (DavResource)iterator.next();
                    if (resource.isDirectory()) {
                        if (!file.getType().contains(AbstractPath.Type.directory)) {
                            throw new NotfoundException(String.format("Path %s is directory", file.getAbsolute()));
                        }
                    } else if (!file.getType().contains(AbstractPath.Type.file)) {
                        throw new NotfoundException(String.format("Path %s is file", file.getAbsolute()));
                    }
                    return this.toAttributes(resource);
                }
                throw new NotfoundException(file.getAbsolute());
            }
            catch (SardineException e) {
                try {
                    throw new DAVExceptionMappingService().map("Failure to read attributes of {0}", e, file);
                }
                catch (InteroperabilityException i) {
                    log.warn((Object)String.format("Failure with PROPFIND request for %s. %s", file, i.getMessage()));
                    Map headers = (Map)((DAVClient)((Object)this.session.getClient())).execute((HttpRequestBase)new HttpHead(new DAVPathEncoder().encode(file)), new HeadersResponseHandler());
                    PathAttributes attributes = new PathAttributes();
                    try {
                        attributes.setModificationDate(this.dateParser.parse((String)headers.get("Last-Modified")).getTime());
                    }
                    catch (InvalidDateException p) {
                        log.warn((Object)String.format("%s is not RFC 1123 format %s", headers.get("Last-Modified"), p.getMessage()));
                    }
                    if (!headers.containsKey("Content-Encoding")) {
                        attributes.setSize(NumberUtils.toLong((String)((String)headers.get("Content-Length")), (long)-1L));
                    }
                    if (headers.containsKey("ETag")) {
                        attributes.setETag((String)headers.get("ETag"));
                    }
                    if (headers.containsKey("Content-MD5")) {
                        attributes.setChecksum(Checksum.parse((String)((String)headers.get("Content-MD5"))));
                    }
                    return attributes;
                }
            }
        }
        catch (SardineException e) {
            throw new DAVExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
        catch (IOException e) {
            throw new HttpExceptionMappingService().map(e, file);
        }
    }

    protected PathAttributes toAttributes(DavResource resource) {
        PathAttributes attributes;
        block20: {
            attributes = new PathAttributes();
            Map properties = resource.getCustomPropsNS();
            if (null != properties && properties.containsKey(DAVTimestampFeature.LAST_MODIFIED_CUSTOM_NAMESPACE)) {
                String value = (String)properties.get(DAVTimestampFeature.LAST_MODIFIED_CUSTOM_NAMESPACE);
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    try {
                        if (properties.containsKey(DAVTimestampFeature.LAST_MODIFIED_SERVER_CUSTOM_NAMESPACE)) {
                            String svalue = (String)properties.get(DAVTimestampFeature.LAST_MODIFIED_SERVER_CUSTOM_NAMESPACE);
                            if (StringUtils.isNotBlank((CharSequence)svalue)) {
                                Date server = new RFC1123DateFormatter().parse(svalue);
                                if (server.equals(resource.getModified())) {
                                    attributes.setModificationDate(new RFC1123DateFormatter().parse(value).getTime());
                                } else if (resource.getModified() != null) {
                                    attributes.setModificationDate(resource.getModified().getTime());
                                }
                            } else {
                                log.debug((Object)String.format("Missing value for property %s", DAVTimestampFeature.LAST_MODIFIED_SERVER_CUSTOM_NAMESPACE));
                                if (resource.getModified() != null) {
                                    attributes.setModificationDate(resource.getModified().getTime());
                                }
                            }
                            break block20;
                        }
                        attributes.setModificationDate(new RFC1123DateFormatter().parse(value).getTime());
                    }
                    catch (InvalidDateException e) {
                        log.warn((Object)String.format("Failure parsing property %s with value %s", DAVTimestampFeature.LAST_MODIFIED_CUSTOM_NAMESPACE, value));
                        if (resource.getModified() != null) {
                            attributes.setModificationDate(resource.getModified().getTime());
                        }
                        break block20;
                    }
                }
                log.debug((Object)String.format("Missing value for property %s", DAVTimestampFeature.LAST_MODIFIED_CUSTOM_NAMESPACE));
                if (resource.getModified() != null) {
                    attributes.setModificationDate(resource.getModified().getTime());
                }
            } else if (resource.getModified() != null) {
                attributes.setModificationDate(resource.getModified().getTime());
            }
        }
        if (resource.getCreation() != null) {
            attributes.setCreationDate(resource.getCreation().getTime());
        }
        if (resource.getContentLength() != null) {
            attributes.setSize(resource.getContentLength().longValue());
        }
        if (StringUtils.isNotBlank((CharSequence)resource.getEtag())) {
            attributes.setETag(resource.getEtag());
        }
        if (StringUtils.isNotBlank((CharSequence)resource.getDisplayName())) {
            attributes.setDisplayname(resource.getDisplayName());
        }
        if (StringUtils.isNotBlank((CharSequence)resource.getDisplayName())) {
            attributes.setDisplayname(resource.getDisplayName());
        }
        return attributes;
    }
}

