/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.AuthMethod;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SystemInfo {
    @JsonProperty(value="languageDefault")
    private String languageDefault = null;
    @JsonProperty(value="authMethods")
    private List<AuthMethod> authMethods = new ArrayList<AuthMethod>();

    public SystemInfo languageDefault(String languageDefault) {
        this.languageDefault = languageDefault;
        return this;
    }

    @ApiModelProperty(example="de", required=true, value="System default language cf. [RFC 5646](https://tools.ietf.org/html/rfc5646)")
    public String getLanguageDefault() {
        return this.languageDefault;
    }

    public void setLanguageDefault(String languageDefault) {
        this.languageDefault = languageDefault;
    }

    public SystemInfo authMethods(List<AuthMethod> authMethods) {
        this.authMethods = authMethods;
        return this;
    }

    public SystemInfo addAuthMethodsItem(AuthMethod authMethodsItem) {
        this.authMethods.add(authMethodsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Authentication methods: * `sql` * `active_directory` * `radius` * `openid`")
    public List<AuthMethod> getAuthMethods() {
        return this.authMethods;
    }

    public void setAuthMethods(List<AuthMethod> authMethods) {
        this.authMethods = authMethods;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemInfo systemInfo = (SystemInfo)o;
        return Objects.equals(this.languageDefault, systemInfo.languageDefault) && Objects.equals(this.authMethods, systemInfo.authMethods);
    }

    public int hashCode() {
        return Objects.hash(this.languageDefault, this.authMethods);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SystemInfo {\n");
        sb.append("    languageDefault: ").append(this.toIndentedString(this.languageDefault)).append("\n");
        sb.append("    authMethods: ").append(this.toIndentedString(this.authMethods)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

