/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import dagger.internal.GwtIncompatible;
import dagger.internal.Preconditions;
import dagger.internal.ReferenceReleasingProvider;
import dagger.releasablereferences.ReleasableReferenceManager;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

@GwtIncompatible
public final class ReferenceReleasingProviderManager
implements ReleasableReferenceManager {
    private final Class<? extends Annotation> scope;
    private final Queue<WeakReference<ReferenceReleasingProvider<?>>> providers = new ConcurrentLinkedQueue();

    public ReferenceReleasingProviderManager(Class<? extends Annotation> scope) {
        this.scope = Preconditions.checkNotNull(scope);
    }

    public void addProvider(ReferenceReleasingProvider<?> provider) {
        this.providers.add(new WeakReference(provider));
    }

    @Override
    public Class<? extends Annotation> scope() {
        return this.scope;
    }

    @Override
    public void releaseStrongReferences() {
        this.execute(Operation.RELEASE);
    }

    @Override
    public void restoreStrongReferences() {
        this.execute(Operation.RESTORE);
    }

    private void execute(Operation operation) {
        Iterator iterator = this.providers.iterator();
        while (iterator.hasNext()) {
            ReferenceReleasingProvider provider = (ReferenceReleasingProvider)((WeakReference)iterator.next()).get();
            if (provider == null) {
                iterator.remove();
                continue;
            }
            operation.execute(provider);
        }
    }

    private static enum Operation {
        RELEASE{

            @Override
            void execute(ReferenceReleasingProvider<?> provider) {
                provider.releaseStrongReference();
            }
        }
        ,
        RESTORE{

            @Override
            void execute(ReferenceReleasingProvider<?> provider) {
                provider.restoreStrongReference();
            }
        };


        abstract void execute(ReferenceReleasingProvider<?> var1);
    }
}

