/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.utils.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\b\u001a\u00020\tH\u0096\u0002J\u000e\u0010\n\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u000bR\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/spectralogic/ds3client/utils/collections/WindowedIterator;", "T", "", "iterator", "windowSize", "", "(Ljava/util/Iterator;I)V", "count", "hasNext", "", "next", "()Ljava/lang/Object;", "ds3-sdk"})
public final class WindowedIterator<T>
implements Iterator<T>,
KMappedMarker {
    private int count;
    private final Iterator<T> iterator;
    private final int windowSize;

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw (Throwable)new NoSuchElementException("There are no new items to return");
        }
        int n = this.count;
        this.count = n + 1;
        return this.iterator.next();
    }

    @Override
    public boolean hasNext() {
        return this.count >= this.windowSize ? false : this.iterator.hasNext();
    }

    public WindowedIterator(@NotNull Iterator<? extends T> iterator, int windowSize) {
        Intrinsics.checkParameterIsNotNull(iterator, (String)"iterator");
        this.iterator = iterator;
        this.windowSize = windowSize;
        if (this.windowSize <= 0) {
            throw (Throwable)new IllegalArgumentException("windowSize must be larger than 0");
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

