/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.WritePreferenceLevel;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class PutTapeStorageDomainMemberSpectraS3Request
extends AbstractRequest {
    private final String storageDomainId;
    private final String tapePartitionId;
    private final String tapeType;
    private Integer autoCompactionThreshold;
    private WritePreferenceLevel writePreference;

    public PutTapeStorageDomainMemberSpectraS3Request(UUID storageDomainId, UUID tapePartitionId, String tapeType) {
        this.storageDomainId = storageDomainId.toString();
        this.tapePartitionId = tapePartitionId.toString();
        this.tapeType = tapeType;
        this.updateQueryParam("storage_domain_id", storageDomainId);
        this.updateQueryParam("tape_partition_id", tapePartitionId);
        this.updateQueryParam("tape_type", tapeType);
    }

    public PutTapeStorageDomainMemberSpectraS3Request(String storageDomainId, String tapePartitionId, String tapeType) {
        this.storageDomainId = storageDomainId;
        this.tapePartitionId = tapePartitionId;
        this.tapeType = tapeType;
        this.updateQueryParam("storage_domain_id", storageDomainId);
        this.updateQueryParam("tape_partition_id", tapePartitionId);
        this.updateQueryParam("tape_type", tapeType);
    }

    public PutTapeStorageDomainMemberSpectraS3Request withAutoCompactionThreshold(Integer autoCompactionThreshold) {
        this.autoCompactionThreshold = autoCompactionThreshold;
        this.updateQueryParam("auto_compaction_threshold", autoCompactionThreshold);
        return this;
    }

    public PutTapeStorageDomainMemberSpectraS3Request withWritePreference(WritePreferenceLevel writePreference) {
        this.writePreference = writePreference;
        this.updateQueryParam("write_preference", writePreference);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.POST;
    }

    @Override
    public String getPath() {
        return "/_rest_/storage_domain_member";
    }

    public String getStorageDomainId() {
        return this.storageDomainId;
    }

    public String getTapePartitionId() {
        return this.tapePartitionId;
    }

    public String getTapeType() {
        return this.tapeType;
    }

    public Integer getAutoCompactionThreshold() {
        return this.autoCompactionThreshold;
    }

    public WritePreferenceLevel getWritePreference() {
        return this.writePreference;
    }
}

