/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.Dimensions;
import com.dropbox.core.v2.files.GpsCoordinates;
import com.dropbox.core.v2.files.MediaMetadata;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public class VideoMetadata
extends MediaMetadata {
    protected final Long duration;

    public VideoMetadata(Dimensions dimensions, GpsCoordinates location, Date timeTaken, Long duration) {
        super(dimensions, location, timeTaken);
        this.duration = duration;
    }

    public VideoMetadata() {
        this(null, null, null, null);
    }

    @Override
    public Dimensions getDimensions() {
        return this.dimensions;
    }

    @Override
    public GpsCoordinates getLocation() {
        return this.location;
    }

    @Override
    public Date getTimeTaken() {
        return this.timeTaken;
    }

    public Long getDuration() {
        return this.duration;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.duration});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            VideoMetadata other = (VideoMetadata)obj;
            return (this.dimensions == other.dimensions || this.dimensions != null && this.dimensions.equals(other.dimensions)) && (this.location == other.location || this.location != null && this.location.equals(other.location)) && (this.timeTaken == other.timeTaken || this.timeTaken != null && this.timeTaken.equals(other.timeTaken)) && (this.duration == other.duration || this.duration != null && this.duration.equals(other.duration));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<VideoMetadata> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(VideoMetadata value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            this.writeTag("video", g);
            if (value.dimensions != null) {
                g.writeFieldName("dimensions");
                StoneSerializers.nullableStruct(Dimensions.Serializer.INSTANCE).serialize(value.dimensions, g);
            }
            if (value.location != null) {
                g.writeFieldName("location");
                StoneSerializers.nullableStruct(GpsCoordinates.Serializer.INSTANCE).serialize(value.location, g);
            }
            if (value.timeTaken != null) {
                g.writeFieldName("time_taken");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.timeTaken, g);
            }
            if (value.duration != null) {
                g.writeFieldName("duration");
                StoneSerializers.nullable(StoneSerializers.uInt64()).serialize(value.duration, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public VideoMetadata deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Long f_duration;
            Date f_timeTaken;
            GpsCoordinates f_location;
            Dimensions f_dimensions;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
                if ("video".equals(tag)) {
                    tag = null;
                }
            }
            if (tag == null) {
                f_dimensions = null;
                f_location = null;
                f_timeTaken = null;
                f_duration = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("dimensions".equals(field)) {
                        f_dimensions = StoneSerializers.nullableStruct(Dimensions.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("location".equals(field)) {
                        f_location = StoneSerializers.nullableStruct(GpsCoordinates.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("time_taken".equals(field)) {
                        f_timeTaken = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    if ("duration".equals(field)) {
                        f_duration = StoneSerializers.nullable(StoneSerializers.uInt64()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            VideoMetadata value = new VideoMetadata(f_dimensions, f_location, f_timeTaken, f_duration);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder
    extends MediaMetadata.Builder {
        protected Long duration = null;

        protected Builder() {
        }

        public Builder withDuration(Long duration) {
            this.duration = duration;
            return this;
        }

        @Override
        public Builder withDimensions(Dimensions dimensions) {
            super.withDimensions(dimensions);
            return this;
        }

        @Override
        public Builder withLocation(GpsCoordinates location) {
            super.withLocation(location);
            return this;
        }

        @Override
        public Builder withTimeTaken(Date timeTaken) {
            super.withTimeTaken(timeTaken);
            return this;
        }

        @Override
        public VideoMetadata build() {
            return new VideoMetadata(this.dimensions, this.location, this.timeTaken, this.duration);
        }
    }
}

