/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.dropbox.core.DbxRequestUtil;
import com.dropbox.core.android.DbxOfficialAppConnector;
import com.dropbox.core.android.FixedSecureRandom;
import java.security.SecureRandom;
import java.util.List;
import java.util.Locale;

public class AuthActivity
extends Activity {
    private static final String TAG = AuthActivity.class.getName();
    public static final String EXTRA_CONSUMER_KEY = "CONSUMER_KEY";
    public static final String EXTRA_ACCESS_TOKEN = "ACCESS_TOKEN";
    public static final String EXTRA_ACCESS_SECRET = "ACCESS_SECRET";
    public static final String EXTRA_UID = "UID";
    public static final String EXTRA_CONSUMER_SIG = "CONSUMER_SIG";
    public static final String EXTRA_CALLING_PACKAGE = "CALLING_PACKAGE";
    public static final String EXTRA_CALLING_CLASS = "CALLING_CLASS";
    public static final String EXTRA_AUTH_STATE = "AUTH_STATE";
    public static final String EXTRA_DESIRED_UID = "DESIRED_UID";
    public static final String EXTRA_ALREADY_AUTHED_UIDS = "ALREADY_AUTHED_UIDS";
    public static final String EXTRA_SESSION_ID = "SESSION_ID";
    public static final String ACTION_AUTHENTICATE_V1 = "com.dropbox.android.AUTHENTICATE_V1";
    public static final String ACTION_AUTHENTICATE_V2 = "com.dropbox.android.AUTHENTICATE_V2";
    public static final int AUTH_VERSION = 1;
    public static final String AUTH_PATH_CONNECT = "/connect";
    private static final String DEFAULT_WEB_HOST = "www.dropbox.com";
    private static final String SIS_KEY_AUTH_STATE_NONCE = "SIS_KEY_AUTH_STATE_NONCE";
    private static SecurityProvider sSecurityProvider = new SecurityProvider(){

        @Override
        public SecureRandom getSecureRandom() {
            return FixedSecureRandom.get();
        }
    };
    private static final Object sSecurityProviderLock = new Object();
    public static Intent result = null;
    private static String sAppKey;
    private static String sWebHost;
    private static String sApiType;
    private static String sDesiredUid;
    private static String[] sAlreadyAuthedUids;
    private static String sSessionId;
    private String mAppKey;
    private String mWebHost;
    private String mApiType;
    private String mDesiredUid;
    private String[] mAlreadyAuthedUids;
    private String mSessionId;
    private String mAuthStateNonce = null;
    private boolean mActivityDispatchHandlerPosted = false;

    static void setAuthParams(String appKey, String desiredUid, String[] alreadyAuthedUids) {
        AuthActivity.setAuthParams(appKey, desiredUid, alreadyAuthedUids, null);
    }

    static void setAuthParams(String appKey, String desiredUid, String[] alreadyAuthedUids, String webHost, String apiType) {
        AuthActivity.setAuthParams(appKey, desiredUid, alreadyAuthedUids, null, null, null);
    }

    static void setAuthParams(String appKey, String desiredUid, String[] alreadyAuthedUids, String sessionId) {
        AuthActivity.setAuthParams(appKey, desiredUid, alreadyAuthedUids, sessionId, null, null);
    }

    static void setAuthParams(String appKey, String desiredUid, String[] alreadyAuthedUids, String sessionId, String webHost, String apiType) {
        sAppKey = appKey;
        sDesiredUid = desiredUid;
        sAlreadyAuthedUids = alreadyAuthedUids != null ? alreadyAuthedUids : new String[]{};
        sSessionId = sessionId;
        sWebHost = webHost != null ? webHost : DEFAULT_WEB_HOST;
        sApiType = apiType;
    }

    public static Intent makeIntent(Context context, String appKey, String webHost, String apiType) {
        return AuthActivity.makeIntent(context, appKey, null, null, null, webHost, apiType);
    }

    public static Intent makeIntent(Context context, String appKey, String desiredUid, String[] alreadyAuthedUids, String sessionId, String webHost, String apiType) {
        if (appKey == null) {
            throw new IllegalArgumentException("'appKey' can't be null");
        }
        AuthActivity.setAuthParams(appKey, desiredUid, alreadyAuthedUids, sessionId, webHost, apiType);
        return new Intent(context, AuthActivity.class);
    }

    public static boolean checkAppBeforeAuth(Context context, String appKey, boolean alertUser) {
        Intent testIntent = new Intent("android.intent.action.VIEW");
        String scheme = "db-" + appKey;
        String uri = scheme + "://" + 1 + AUTH_PATH_CONNECT;
        testIntent.setData(Uri.parse((String)uri));
        PackageManager pm = context.getPackageManager();
        List activities = pm.queryIntentActivities(testIntent, 0);
        if (null == activities || 0 == activities.size()) {
            throw new IllegalStateException("URI scheme in your app's manifest is not set up correctly. You should have a " + AuthActivity.class.getName() + " with the scheme: " + scheme);
        }
        if (activities.size() > 1) {
            if (alertUser) {
                AlertDialog.Builder builder = new AlertDialog.Builder(context);
                builder.setTitle((CharSequence)"Security alert");
                builder.setMessage((CharSequence)"Another app on your phone may be trying to pose as the app you are currently using. The malicious app can't access your account, but linking to Dropbox has been disabled as a precaution. Please contact support@dropbox.com.");
                builder.setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                builder.show();
            } else {
                Log.w((String)TAG, (String)("There are multiple apps registered for the AuthActivity URI scheme (" + scheme + ").  Another app may be trying to  impersonate this app, so authentication will be disabled."));
            }
            return false;
        }
        ResolveInfo resolveInfo = (ResolveInfo)activities.get(0);
        if (null == resolveInfo || null == resolveInfo.activityInfo || !context.getPackageName().equals(resolveInfo.activityInfo.packageName)) {
            throw new IllegalStateException("There must be a " + AuthActivity.class.getName() + " within your app's package registered for your URI scheme (" + scheme + "). However, it appears that an activity in a different package is registered for that scheme instead. If you have multiple apps that all want to use the same accesstoken pair, designate one of them to do authentication and have the other apps launch it and then retrieve the token pair from it.");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSecurityProvider(SecurityProvider prov) {
        Object object = sSecurityProviderLock;
        synchronized (object) {
            sSecurityProvider = prov;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SecurityProvider getSecurityProvider() {
        Object object = sSecurityProviderLock;
        synchronized (object) {
            return sSecurityProvider;
        }
    }

    private static SecureRandom getSecureRandom() {
        SecurityProvider prov = AuthActivity.getSecurityProvider();
        if (null != prov) {
            return prov.getSecureRandom();
        }
        return new SecureRandom();
    }

    protected void onCreate(Bundle savedInstanceState) {
        this.mAppKey = sAppKey;
        this.mWebHost = sWebHost;
        this.mApiType = sApiType;
        this.mDesiredUid = sDesiredUid;
        this.mAlreadyAuthedUids = sAlreadyAuthedUids;
        this.mSessionId = sSessionId;
        if (savedInstanceState == null) {
            result = null;
            this.mAuthStateNonce = null;
        } else {
            this.mAuthStateNonce = savedInstanceState.getString(SIS_KEY_AUTH_STATE_NONCE);
        }
        this.setTheme(0x1030010);
        super.onCreate(savedInstanceState);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(SIS_KEY_AUTH_STATE_NONCE, this.mAuthStateNonce);
    }

    static Intent getOfficialAuthIntent() {
        Intent authIntent = new Intent(ACTION_AUTHENTICATE_V2);
        authIntent.setPackage("com.dropbox.android");
        return authIntent;
    }

    protected void onResume() {
        super.onResume();
        if (this.isFinishing()) {
            return;
        }
        if (this.mAuthStateNonce != null || this.mAppKey == null) {
            this.authFinished(null);
            return;
        }
        result = null;
        if (this.mActivityDispatchHandlerPosted) {
            Log.w((String)TAG, (String)"onResume called again before Handler run");
            return;
        }
        final String state = this.createStateNonce();
        final Intent officialAuthIntent = AuthActivity.getOfficialAuthIntent();
        officialAuthIntent.putExtra(EXTRA_CONSUMER_KEY, this.mAppKey);
        officialAuthIntent.putExtra(EXTRA_CONSUMER_SIG, "");
        officialAuthIntent.putExtra(EXTRA_DESIRED_UID, this.mDesiredUid);
        officialAuthIntent.putExtra(EXTRA_ALREADY_AUTHED_UIDS, this.mAlreadyAuthedUids);
        officialAuthIntent.putExtra(EXTRA_SESSION_ID, this.mSessionId);
        officialAuthIntent.putExtra(EXTRA_CALLING_PACKAGE, this.getPackageName());
        officialAuthIntent.putExtra(EXTRA_CALLING_CLASS, ((Object)((Object)this)).getClass().getName());
        officialAuthIntent.putExtra(EXTRA_AUTH_STATE, state);
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                Log.d((String)TAG, (String)"running startActivity in handler");
                try {
                    if (DbxOfficialAppConnector.getDropboxAppPackage((Context)AuthActivity.this, officialAuthIntent) != null) {
                        AuthActivity.this.startActivity(officialAuthIntent);
                    } else {
                        AuthActivity.this.startWebAuth(state);
                    }
                }
                catch (ActivityNotFoundException e) {
                    Log.e((String)TAG, (String)"Could not launch intent. User may have restricted profile", (Throwable)e);
                    AuthActivity.this.finish();
                    return;
                }
                AuthActivity.this.mAuthStateNonce = state;
                AuthActivity.setAuthParams(null, null, null);
            }
        });
        this.mActivityDispatchHandlerPosted = true;
    }

    protected void onNewIntent(Intent intent) {
        Intent newResult;
        if (null == this.mAuthStateNonce) {
            this.authFinished(null);
            return;
        }
        String token = null;
        String secret = null;
        String uid = null;
        String state = null;
        if (intent.hasExtra(EXTRA_ACCESS_TOKEN)) {
            token = intent.getStringExtra(EXTRA_ACCESS_TOKEN);
            secret = intent.getStringExtra(EXTRA_ACCESS_SECRET);
            uid = intent.getStringExtra(EXTRA_UID);
            state = intent.getStringExtra(EXTRA_AUTH_STATE);
        } else {
            String path;
            Uri uri = intent.getData();
            if (uri != null && AUTH_PATH_CONNECT.equals(path = uri.getPath())) {
                try {
                    token = uri.getQueryParameter("oauth_token");
                    secret = uri.getQueryParameter("oauth_token_secret");
                    uid = uri.getQueryParameter("uid");
                    state = uri.getQueryParameter("state");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
        }
        if (!(token == null || token.equals("") || secret == null || secret.equals("") || uid == null || uid.equals("") || state == null || state.equals(""))) {
            if (!this.mAuthStateNonce.equals(state)) {
                this.authFinished(null);
                return;
            }
            newResult = new Intent();
            newResult.putExtra(EXTRA_ACCESS_TOKEN, token);
            newResult.putExtra(EXTRA_ACCESS_SECRET, secret);
            newResult.putExtra(EXTRA_UID, uid);
        } else {
            newResult = null;
        }
        this.authFinished(newResult);
    }

    private void authFinished(Intent authResult) {
        result = authResult;
        this.mAuthStateNonce = null;
        AuthActivity.setAuthParams(null, null, null);
        this.finish();
    }

    private void startWebAuth(String state) {
        String path = "1/connect";
        Locale locale = Locale.getDefault();
        locale = new Locale(locale.getLanguage(), locale.getCountry());
        String alreadyAuthedUid = this.mAlreadyAuthedUids.length > 0 ? this.mAlreadyAuthedUids[0] : "0";
        String[] params = new String[]{"k", this.mAppKey, "n", alreadyAuthedUid, "api", this.mApiType, "state", state};
        String url = DbxRequestUtil.buildUrlWithParams(locale.toString(), this.mWebHost, path, params);
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        this.startActivity(intent);
    }

    private String createStateNonce() {
        int NONCE_BYTES = 16;
        byte[] randomBytes = new byte[16];
        AuthActivity.getSecureRandom().nextBytes(randomBytes);
        StringBuilder sb = new StringBuilder();
        sb.append("oauth2:");
        for (int i = 0; i < 16; ++i) {
            sb.append(String.format("%02x", randomBytes[i] & 0xFF));
        }
        return sb.toString();
    }

    static {
        sWebHost = DEFAULT_WEB_HOST;
    }

    public static interface SecurityProvider {
        public SecureRandom getSecureRandom();
    }
}

