/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import com.dropbox.core.DbxException;
import com.dropbox.core.NetworkIOException;
import com.dropbox.core.util.IOUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DbxDownloader<R>
implements Closeable {
    private final R result;
    private final InputStream body;
    private boolean closed;

    public DbxDownloader(R result, InputStream body) {
        this.result = result;
        this.body = body;
        this.closed = false;
    }

    public R getResult() {
        return this.result;
    }

    public InputStream getInputStream() {
        this.assertOpen();
        return this.body;
    }

    public R download(OutputStream out) throws DbxException, IOException {
        try {
            IOUtil.copyStreamToStream(this.getInputStream(), out);
        }
        catch (IOUtil.WriteException ex) {
            throw ex.getCause();
        }
        catch (IOException ex) {
            throw new NetworkIOException(ex);
        }
        finally {
            this.close();
        }
        return this.result;
    }

    @Override
    public void close() {
        if (!this.closed) {
            IOUtil.closeQuietly(this.body);
            this.closed = true;
        }
    }

    private void assertOpen() {
        if (this.closed) {
            throw new IllegalStateException("This downloader is already closed.");
        }
    }
}

