/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.cli;

import ch.cyberduck.cli.Console;
import ch.cyberduck.cli.InteractiveTerminalPromptReader;
import ch.cyberduck.cli.TerminalPromptReader;
import ch.cyberduck.core.DefaultCertificateStore;
import ch.cyberduck.core.LocaleFactory;
import com.amazonaws.util.StringUtils;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLException;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;

public class TerminalCertificateStore
extends DefaultCertificateStore {
    private final Console console = new Console();
    private final DefaultHostnameVerifier verifier = new DefaultHostnameVerifier();
    private final TerminalPromptReader prompt;

    public TerminalCertificateStore() {
        this.prompt = new InteractiveTerminalPromptReader();
    }

    public TerminalCertificateStore(TerminalPromptReader prompt) {
        this.prompt = prompt;
    }

    @Override
    public boolean display(List<X509Certificate> certificates) {
        for (X509Certificate c : certificates) {
            this.console.printf("%n%s", c.toString());
        }
        return true;
    }

    @Override
    public boolean isTrusted(String hostname, List<X509Certificate> certificates) {
        if (certificates.isEmpty()) {
            return false;
        }
        for (X509Certificate c : certificates) {
            try {
                c.checkValidity();
            }
            catch (CertificateExpiredException e) {
                return this.prompt.prompt(LocaleFactory.localizedString(StringUtils.replace((String)"The certificate for this server has expired. You might be connecting to a server that is pretending to be \u201c%@\u201d which could put your confidential information at risk. Would you like to connect to the server anyway?", (String)"%@", (String)hostname), "Keychain"));
            }
            catch (CertificateNotYetValidException e) {
                return this.prompt.prompt(LocaleFactory.localizedString(StringUtils.replace((String)"The certificate for this server is not yet valid. You might be connecting to a server that is pretending to be \u201c%@\u201d which could put your confidential information at risk. Would you like to connect to the server anyway?", (String)"%@", (String)hostname), "Keychain"));
            }
        }
        try {
            this.verifier.verify(hostname, certificates.get(0));
        }
        catch (SSLException e) {
            return this.prompt.prompt(LocaleFactory.localizedString(StringUtils.replace((String)"The certificate for this server is invalid. You might be connecting to a server that is pretending to be \u201c%@\u201d which could put your confidential information at risk. Would you like to connect to the server anyway?", (String)"%@", (String)hostname), "Keychain"));
        }
        return true;
    }
}

