/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.onedrive.OneDriveExceptionMappingService;
import ch.cyberduck.core.onedrive.OneDriveSession;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveItem;

public class OneDriveDeleteFeature
implements Delete {
    private static final Logger logger = Logger.getLogger(OneDriveDeleteFeature.class);
    private final PathContainerService containerService = new PathContainerService();
    private final OneDriveSession session;

    public OneDriveDeleteFeature(OneDriveSession session) {
        this.session = session;
    }

    public void delete(List<Path> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        for (Path file : files) {
            if (this.containerService.isContainer(file)) continue;
            callback.delete(file);
            try {
                OneDriveItem item = this.session.toItem(file);
                item.delete();
            }
            catch (NotfoundException e) {
                logger.warn((Object)String.format("Cannot delete %s. Not found.", file));
            }
            catch (OneDriveAPIException e) {
                throw new OneDriveExceptionMappingService().map("Cannot delete {0}", e, file);
            }
            catch (IOException e) {
                throw new DefaultIOExceptionMappingService().map("Cannot delete {0}", (Throwable)e, file);
            }
        }
    }

    public boolean isSupported(Path file) {
        return !this.containerService.isContainer(file);
    }

    public boolean isRecursive() {
        return true;
    }
}

