/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3Session;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.acl.GranteeInterface;
import org.jets3t.service.acl.Permission;
import org.jets3t.service.acl.gs.AllAuthenticatedUsersGrantee;
import org.jets3t.service.acl.gs.AllUsersGrantee;
import org.jets3t.service.acl.gs.GSAccessControlList;
import org.jets3t.service.acl.gs.GroupByDomainGrantee;
import org.jets3t.service.acl.gs.GroupByEmailAddressGrantee;
import org.jets3t.service.acl.gs.GroupByIdGrantee;
import org.jets3t.service.acl.gs.UserByEmailAddressGrantee;
import org.jets3t.service.acl.gs.UserByIdGrantee;

public class GoogleStorageAccessControlListFeature
extends S3AccessControlListFeature {
    private static final Logger log = Logger.getLogger(GoogleStorageAccessControlListFeature.class);

    public GoogleStorageAccessControlListFeature(GoogleStorageSession session) {
        super((S3Session)session);
    }

    protected AccessControlList convert(Acl acl) {
        GSAccessControlList list = new GSAccessControlList();
        for (Acl.UserAndRole userAndRole : acl.asList()) {
            if (!userAndRole.isValid()) continue;
            if (userAndRole.getUser() instanceof Acl.EmailUser) {
                list.grantPermission((GranteeInterface)new UserByEmailAddressGrantee(userAndRole.getUser().getIdentifier()), Permission.parsePermission((String)userAndRole.getRole().getName()));
                continue;
            }
            if (userAndRole.getUser() instanceof Acl.GroupUser) {
                if (userAndRole.getUser().getIdentifier().equals(new AllUsersGrantee().getIdentifier()) || userAndRole.getUser().getIdentifier().equals("AllUsers")) {
                    list.grantPermission((GranteeInterface)new AllUsersGrantee(), Permission.parsePermission((String)userAndRole.getRole().getName()));
                    continue;
                }
                if (userAndRole.getUser().getIdentifier().equals(new AllAuthenticatedUsersGrantee().getIdentifier()) || userAndRole.getUser().getIdentifier().equals("AllAuthenticatedUsers")) {
                    list.grantPermission((GranteeInterface)new AllAuthenticatedUsersGrantee(), Permission.parsePermission((String)userAndRole.getRole().getName()));
                    continue;
                }
                list.grantPermission((GranteeInterface)new GroupByIdGrantee(userAndRole.getUser().getIdentifier()), Permission.parsePermission((String)userAndRole.getRole().getName()));
                continue;
            }
            if (userAndRole.getUser() instanceof Acl.DomainUser) {
                list.grantPermission((GranteeInterface)new GroupByDomainGrantee(userAndRole.getUser().getIdentifier()), Permission.parsePermission((String)userAndRole.getRole().getName()));
                continue;
            }
            if (userAndRole.getUser() instanceof Acl.CanonicalUser) {
                list.grantPermission((GranteeInterface)new UserByIdGrantee(userAndRole.getUser().getIdentifier()), Permission.parsePermission((String)userAndRole.getRole().getName()));
                continue;
            }
            if (userAndRole.getUser() instanceof Acl.EmailGroupUser) {
                list.grantPermission((GranteeInterface)new GroupByEmailAddressGrantee(userAndRole.getUser().getIdentifier()), Permission.parsePermission((String)userAndRole.getRole().getName()));
                continue;
            }
            log.warn((Object)("Unsupported user:" + userAndRole.getUser()));
        }
        if (log.isDebugEnabled()) {
            try {
                log.debug((Object)list.toXml());
            }
            catch (ServiceException e) {
                log.error((Object)e.getMessage());
            }
        }
        return list;
    }

    public List<Acl.User> getAvailableAclUsers() {
        ArrayList<Acl.User> users = new ArrayList<Acl.User>(Arrays.asList(new Acl.CanonicalUser(), new Acl.GroupUser("AllAuthenticatedUsers", false), new Acl.GroupUser("AllUsers", false)));
        users.add((Acl.User)new Acl.EmailUser(){

            public String getPlaceholder() {
                return LocaleFactory.localizedString((String)"Google Account Email Address", (String)"S3");
            }
        });
        users.add((Acl.User)new Acl.DomainUser(""){

            public String getPlaceholder() {
                return LocaleFactory.localizedString((String)"Google Apps Domain", (String)"S3");
            }
        });
        users.add((Acl.User)new Acl.EmailGroupUser("", true){

            public String getPlaceholder() {
                return LocaleFactory.localizedString((String)"Google Group Email Address", (String)"S3");
            }
        });
        return users;
    }

    public List<Acl.Role> getAvailableAclRoles(List<Path> files) {
        ArrayList<Acl.Role> roles = new ArrayList<Acl.Role>(Arrays.asList(new Acl.Role(Permission.PERMISSION_FULL_CONTROL.toString()), new Acl.Role(Permission.PERMISSION_READ.toString())));
        for (Path file : files) {
            if (!file.isVolume()) continue;
            roles.add(new Acl.Role(Permission.PERMISSION_WRITE.toString()));
            break;
        }
        return roles;
    }
}

