/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.DefaultStreamCloser;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.s3.S3AttributesFinderFeature;
import ch.cyberduck.core.s3.S3DisabledMultipartService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.s3.S3WriteFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.input.NullInputStream;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.StorageObject;

public class S3TouchFeature
implements Touch<StorageObject> {
    private final S3Session session;
    private Write<StorageObject> writer;

    public S3TouchFeature(S3Session session) {
        this.session = session;
        this.writer = new S3WriteFeature(session, new S3DisabledMultipartService());
    }

    public Path touch(Path file, TransferStatus status) throws BackgroundException {
        if (Checksum.NONE == status.getChecksum()) {
            status.setChecksum(this.writer.checksum(file).compute((InputStream)new NullInputStream(0L), status));
        }
        status.setLength(0L);
        StatusOutputStream out = this.writer.write(file, status, (ConnectionCallback)new DisabledConnectionCallback());
        new DefaultStreamCloser().close((OutputStream)out);
        S3Object metadata = (S3Object)out.getStatus();
        return new Path(file.getParent(), file.getName(), file.getType(), new S3AttributesFinderFeature(this.session).toAttributes((StorageObject)metadata));
    }

    public boolean isSupported(Path workdir) {
        return !workdir.isRoot();
    }

    public Touch<StorageObject> withWriter(Write<StorageObject> writer) {
        this.writer = writer;
        return this;
    }
}

