/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.S3ObjectListService;
import ch.cyberduck.core.s3.S3Session;
import java.util.HashSet;

public class S3SearchFeature
implements Search {
    private final S3Session session;

    public S3SearchFeature(S3Session session) {
        this.session = session;
    }

    public AttributedList<Path> search(Path workdir, Filter<Path> regex, ListProgressListener listener) throws BackgroundException {
        AttributedList<Path> objects = new S3ObjectListService(this.session).list(workdir, listener, null, PreferencesFactory.get().getInteger("s3.listing.chunksize"));
        HashSet<Path> removal = new HashSet<Path>();
        for (Path f : objects) {
            if (f.getName().contains(regex.toPattern().pattern())) continue;
            removal.add(f);
        }
        objects.removeAll(removal);
        return objects;
    }

    public boolean isRecursive() {
        return false;
    }

    public Search withCache(Cache<Path> cache) {
        return this;
    }
}

