/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.http;

import com.joyent.manta.config.MantaClientMetricConfiguration;
import com.joyent.manta.exception.MantaIOException;
import com.joyent.manta.exception.MantaNoHttpResponseException;
import com.joyent.manta.http.HttpHelper;
import com.joyent.manta.http.InstrumentedMantaHttpRequestExecutor;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;
import org.slf4j.MDC;

public class MantaHttpRequestExecutor
extends HttpRequestExecutor {
    public MantaHttpRequestExecutor() {
    }

    public MantaHttpRequestExecutor(int waitForContinue) {
        super(waitForContinue);
    }

    protected HttpResponse doSendRequest(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
        MDC.put((String)"mantaLoadBalancerAddress", (String)MantaHttpRequestExecutor.extractLoadBalancerAddress(conn));
        return super.doSendRequest(request, conn, context);
    }

    protected HttpResponse doReceiveResponse(HttpRequest request, HttpClientConnection conn, HttpContext context) throws HttpException, IOException {
        HttpResponse response = null;
        try {
            response = super.doReceiveResponse(request, conn, context);
        }
        catch (IOException e) {
            MantaIOException mioe = e instanceof NoHttpResponseException ? new MantaNoHttpResponseException(e) : new MantaIOException(e);
            HttpHelper.annotateContextedException(mioe, request, response);
            if (request.getFirstHeader("x-request-id") != null) {
                mioe.setContextValue("requestId", request.getFirstHeader("x-request-id").getValue());
            }
            mioe.setContextValue("loadBalancerAddress", MantaHttpRequestExecutor.extractLoadBalancerAddress(conn));
            throw mioe;
        }
        if (!response.containsHeader("x-load-balancer")) {
            response.setHeader("x-load-balancer", MantaHttpRequestExecutor.extractLoadBalancerAddress(conn));
        }
        return response;
    }

    private static String extractLoadBalancerAddress(HttpClientConnection conn) {
        if (conn == null) {
            return null;
        }
        return StringUtils.substringBetween((String)conn.toString(), (String)"<->", (String)":");
    }

    static final class Builder {
        private Integer waitForContinue;
        private MantaClientMetricConfiguration metricConfig;

        Builder() {
        }

        static Builder create() {
            return new Builder();
        }

        Builder setWaitForContinue(Integer waitForContinue) {
            this.waitForContinue = waitForContinue;
            return this;
        }

        Builder setMetricConfiguration(MantaClientMetricConfiguration metricConfiguration) {
            this.metricConfig = metricConfiguration;
            return this;
        }

        MantaHttpRequestExecutor build() {
            if (this.metricConfig != null) {
                if (this.waitForContinue != null) {
                    return new InstrumentedMantaHttpRequestExecutor(this.metricConfig.getRegistry(), this.waitForContinue);
                }
                return new InstrumentedMantaHttpRequestExecutor(this.metricConfig.getRegistry());
            }
            if (this.waitForContinue != null) {
                return new MantaHttpRequestExecutor(this.waitForContinue);
            }
            return new MantaHttpRequestExecutor();
        }
    }
}

