/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.samples;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.jets3t.samples.SamplesUtils;
import org.jets3t.service.Constants;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.acl.CanonicalGrantee;
import org.jets3t.service.acl.EmailAddressGrantee;
import org.jets3t.service.acl.GroupGrantee;
import org.jets3t.service.acl.Permission;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.BaseVersionOrDeleteMarker;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3BucketVersioningStatus;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.multithread.DownloadPackage;
import org.jets3t.service.multithread.S3ServiceSimpleMulti;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.AWSDevPayCredentials;
import org.jets3t.service.security.ProviderCredentials;
import org.jets3t.service.utils.MultipartUtils;
import org.jets3t.service.utils.ServiceUtils;

public class CodeSamples {
    private static final String BUCKET_NAME = "test-bucket";
    private static final String TEST_OBJECT_NAME = "helloworld.txt";

    public static void main(String[] args) throws Exception {
        String finalVersionId;
        S3Object versionedObject;
        S3BucketVersioningStatus versioningStatus;
        String vBucketName;
        RestS3Service s3Service;
        AWSCredentials awsCredentials;
        block12: {
            awsCredentials = SamplesUtils.loadAWSCredentials();
            s3Service = new RestS3Service(awsCredentials);
            S3Bucket[] myBuckets = s3Service.listAllBuckets();
            System.out.println("How many buckets do I have in S3? " + myBuckets.length);
            S3Bucket testBucket = s3Service.createBucket(BUCKET_NAME);
            System.out.println("Created test bucket: " + testBucket.getName());
            S3Bucket euBucket = s3Service.createBucket("eu-bucket", "EU");
            S3Bucket usWestBucket = s3Service.createBucket("us-west-bucket", "us-west-1");
            S3Bucket asiaPacificBucket = s3Service.createBucket("asia-pacific-bucket", "ap-southeast-1");
            S3Object object = new S3Object("object");
            System.out.println("S3Object before upload: " + object);
            object = s3Service.putObject(testBucket, object);
            System.out.println("S3Object after upload: " + object);
            String stringData = "Hello World!";
            S3Object stringObject = new S3Object(TEST_OBJECT_NAME, stringData);
            File fileData = new File("src/org/jets3t/samples/CodeSamples.java");
            S3Object fileObject = new S3Object(fileData);
            String greeting = "Hello World!";
            S3Object helloWorldObject = new S3Object("HelloWorld2.txt");
            ByteArrayInputStream greetingIS = new ByteArrayInputStream(greeting.getBytes(Constants.DEFAULT_ENCODING));
            helloWorldObject.setDataInputStream(greetingIS);
            helloWorldObject.setContentLength(greeting.getBytes(Constants.DEFAULT_ENCODING).length);
            helloWorldObject.setContentType("text/plain");
            s3Service.putObject(testBucket, stringObject);
            s3Service.putObject(testBucket, fileObject);
            s3Service.putObject(testBucket, helloWorldObject);
            System.out.println("S3Object with data: " + helloWorldObject);
            S3Object rrsObject = new S3Object("reduced-redundancy-object");
            rrsObject.setStorageClass("REDUCED_REDUNDANCY");
            s3Service.putObject(testBucket, rrsObject);
            S3Object objectWithHash = new S3Object(TEST_OBJECT_NAME, stringData);
            System.out.println("Hash value: " + objectWithHash.getMd5HashAsHex());
            ByteArrayInputStream dataIS = new ByteArrayInputStream("Here is my data".getBytes(Constants.DEFAULT_ENCODING));
            byte[] md5Hash = ServiceUtils.computeMD5Hash(dataIS);
            dataIS.reset();
            stringObject = new S3Object("MyData");
            stringObject.setDataInputStream(dataIS);
            stringObject.setMd5Hash(md5Hash);
            S3Object objectDetailsOnly = s3Service.getObjectDetails(testBucket, TEST_OBJECT_NAME);
            System.out.println("S3Object, details only: " + objectDetailsOnly);
            S3Object objectComplete = s3Service.getObject(testBucket, TEST_OBJECT_NAME);
            System.out.println("S3Object, complete: " + objectComplete);
            System.out.println("Greeting:");
            BufferedReader reader = new BufferedReader(new InputStreamReader(objectComplete.getDataInputStream()));
            String data = null;
            while ((data = reader.readLine()) != null) {
                System.out.println(data);
            }
            S3Object downloadedObject = s3Service.getObject(testBucket, TEST_OBJECT_NAME);
            String textData = ServiceUtils.readInputStreamToString(downloadedObject.getDataInputStream(), "UTF-8");
            boolean valid = downloadedObject.verifyData(textData.getBytes("UTF-8"));
            System.out.println("Object verified? " + valid);
            S3Bucket[] buckets = s3Service.listAllBuckets();
            for (int b = 0; b < buckets.length; ++b) {
                System.out.println("Bucket '" + buckets[b].getName() + "' contains:");
                S3Object[] objects = s3Service.listObjects(buckets[b]);
                for (int o = 0; o < objects.length; ++o) {
                    System.out.println(" " + objects[o].getKey() + " (" + objects[o].getContentLength() + " bytes)");
                }
            }
            String prefix = "Reports";
            String delimiter = null;
            S3Object[] filteredObjects = s3Service.listObjects(testBucket, prefix, delimiter);
            S3Object targetObject = new S3Object("targetObjectWithSourcesMetadata");
            boolean replaceMetadata = false;
            s3Service.copyObject(BUCKET_NAME, TEST_OBJECT_NAME, "destination-bucket", targetObject, replaceMetadata);
            targetObject = new S3Object(TEST_OBJECT_NAME);
            targetObject.addMetadata("Content-Type", "text/html");
            replaceMetadata = true;
            s3Service.copyObject(BUCKET_NAME, TEST_OBJECT_NAME, BUCKET_NAME, targetObject, replaceMetadata);
            s3Service.moveObject(BUCKET_NAME, TEST_OBJECT_NAME, "destination-bucket", targetObject, false);
            s3Service.moveObject(BUCKET_NAME, TEST_OBJECT_NAME, BUCKET_NAME, new S3Object("NewName.txt"), false);
            s3Service.renameObject(BUCKET_NAME, TEST_OBJECT_NAME, targetObject);
            try {
                s3Service.deleteBucket(testBucket.getName());
            }
            catch (S3ServiceException e) {
                e.printStackTrace();
            }
            s3Service.deleteObject(testBucket, object.getKey());
            s3Service.deleteObject(testBucket, helloWorldObject.getKey());
            s3Service.deleteBucket(testBucket.getName());
            System.out.println("Deleted bucket " + testBucket.getName());
            S3ServiceSimpleMulti simpleMulti = new S3ServiceSimpleMulti(s3Service);
            S3Bucket bucket = new S3Bucket(awsCredentials.getAccessKey() + ".TestMulti");
            bucket = s3Service.createBucket(bucket);
            S3Object[] objects = new S3Object[]{new S3Object("object1.txt", "Hello from object 1"), new S3Object("object2.txt", "Hello from object 2"), new S3Object("object3.txt", "Hello from object 3"), new S3Object("object4.txt", "Hello from object 4"), new S3Object("object5.txt", "Hello from object 5")};
            S3Object[] createdObjects = simpleMulti.putObjects(bucket, objects);
            System.out.println("Uploaded " + createdObjects.length + " objects");
            S3Object[] objectsWithHeadDetails = simpleMulti.getObjectsHeads(bucket, objects);
            System.out.println("Objects with HEAD Details...");
            for (int i = 0; i < objectsWithHeadDetails.length; ++i) {
                System.out.println(objectsWithHeadDetails[i]);
            }
            DownloadPackage[] downloadPackages = new DownloadPackage[]{new DownloadPackage(objects[0], new File(objects[0].getKey())), new DownloadPackage(objects[1], new File(objects[1].getKey())), new DownloadPackage(objects[2], new File(objects[2].getKey())), new DownloadPackage(objects[3], new File(objects[3].getKey())), new DownloadPackage(objects[4], new File(objects[4].getKey()))};
            simpleMulti.downloadObjects(bucket, downloadPackages);
            System.out.println("Downloaded objects to current working directory");
            simpleMulti.deleteObjects(bucket, objects);
            s3Service.deleteBucket(bucket);
            System.out.println("Deleted bucket: " + bucket);
            S3Bucket versioningBucket = s3Service.getOrCreateBucket("test-versioning");
            vBucketName = versioningBucket.getName();
            versioningStatus = s3Service.getBucketVersioningStatus(vBucketName);
            System.out.println("Versioning enabled ? " + versioningStatus.isVersioningEnabled());
            s3Service.suspendBucketVersioning(vBucketName);
            s3Service.enableBucketVersioning(vBucketName);
            versionedObject = new S3Object("versioned-object", "Initial version");
            s3Service.putObject(vBucketName, versionedObject);
            versionedObject = new S3Object("versioned-object", "Second version");
            s3Service.putObject(vBucketName, versionedObject);
            versionedObject = new S3Object("versioned-object", "Final version");
            s3Service.putObject(vBucketName, versionedObject);
            versionedObject = s3Service.getObject(vBucketName, "versioned-object");
            finalVersionId = versionedObject.getVersionId();
            System.out.println("Version ID: " + finalVersionId);
            s3Service.deleteObject(vBucketName, "versioned-object");
            try {
                s3Service.getObject(vBucketName, "versioned-object");
            }
            catch (S3ServiceException e) {
                if (e.getResponseCode() != 404) break block12;
                System.out.println("Is deleted object versioned? " + e.getResponseHeaders().get("x-amz-delete-marker"));
                System.out.println("Delete marker version ID: " + e.getResponseHeaders().get("x-amz-version-id"));
            }
        }
        versionedObject = s3Service.getVersionedObject(finalVersionId, vBucketName, "versioned-object");
        String versionedData = ServiceUtils.readInputStreamToString(versionedObject.getDataInputStream(), "UTF-8");
        System.out.println("Data from prior version of deleted document: " + versionedData);
        BaseVersionOrDeleteMarker[] versions = s3Service.listVersionedObjects(vBucketName, null, null);
        for (int i = 0; i < versions.length; ++i) {
            System.out.println(versions[i]);
        }
        String versionPrefix = "versioned-object";
        versions = s3Service.listVersionedObjects(vBucketName, versionPrefix, null);
        versions = s3Service.getObjectVersions(vBucketName, "versioned-object");
        versionedObject = s3Service.getVersionedObjectDetails(finalVersionId, vBucketName, "versioned-object");
        if (!finalVersionId.equals(versionedObject.getVersionId())) {
            throw new Exception("Incorrect version!");
        }
        s3Service.copyVersionedObject(finalVersionId, vBucketName, "versioned-object", "destination-bucket", new S3Object("copied-from-version"), false, null, null, null, null);
        AccessControlList versionedObjectAcl = s3Service.getVersionedObjectAcl(finalVersionId, vBucketName, "versioned-object");
        s3Service.putVersionedObjectAcl(finalVersionId, vBucketName, "versioned-object", versionedObjectAcl);
        s3Service.deleteVersionedObject(finalVersionId, vBucketName, "versioned-object");
        versions = s3Service.getObjectVersions(vBucketName, "versioned-object");
        String[] versionIds = BaseVersionOrDeleteMarker.toVersionIds(versions);
        new S3ServiceSimpleMulti(s3Service).deleteVersionsOfObject(versionIds, vBucketName, "versioned-object");
        s3Service.enableBucketVersioningAndMFA(vBucketName);
        versioningStatus = s3Service.getBucketVersioningStatus(vBucketName);
        System.out.println("Multi-factor auth required to delete versions ? " + versioningStatus.isMultiFactorAuthDeleteRequired());
        String multiFactorSerialNumber = "#111222333";
        String multiFactorAuthCode = "12345678";
        s3Service.deleteVersionedObjectWithMFA(finalVersionId, multiFactorSerialNumber, multiFactorAuthCode, vBucketName, "versioned-object");
        s3Service.disableMFAForVersionedBucket(vBucketName, multiFactorSerialNumber, multiFactorAuthCode);
        s3Service.suspendBucketVersioningWithMFA(vBucketName, multiFactorSerialNumber, multiFactorAuthCode);
        S3Object objectWithMetadata = new S3Object("metadataObject");
        objectWithMetadata.addMetadata("favourite-colour", "blue");
        objectWithMetadata.addMetadata("document-version", "0.3");
        File credFile = new File("awscredentials.enc");
        awsCredentials.save("password", credFile);
        ProviderCredentials loadedCredentials = AWSCredentials.load("password", credFile);
        System.out.println("AWS Key loaded from file: " + loadedCredentials.getAccessKey());
        try {
            loadedCredentials = AWSCredentials.load("wrongPassword", credFile);
        }
        catch (S3ServiceException e) {
            System.err.println("Cannot load credentials from file with the wrong password!");
        }
        S3Bucket publicBucket = new S3Bucket(awsCredentials.getAccessKey() + ".publicBucket");
        s3Service.createBucket(publicBucket);
        AccessControlList bucketAcl = s3Service.getBucketAcl(publicBucket);
        bucketAcl.grantPermission(GroupGrantee.ALL_USERS, Permission.PERMISSION_READ);
        publicBucket.setAcl(bucketAcl);
        s3Service.putBucketAcl(publicBucket);
        System.out.println("View bucket's object listing here: http://s3.amazonaws.com/" + publicBucket.getName());
        S3Object publicObject = new S3Object("publicObject.txt", "This object is public");
        publicObject.setAcl(bucketAcl);
        s3Service.putObject(publicBucket, publicObject);
        System.out.println("View public object contents here: http://s3.amazonaws.com/" + publicBucket.getName() + "/" + publicObject.getKey());
        AccessControlList acl = new AccessControlList();
        acl.grantPermission(new EmailAddressGrantee("someone@somewhere.com"), Permission.PERMISSION_FULL_CONTROL);
        acl.grantPermission(new CanonicalGrantee("AWS member's ID"), Permission.PERMISSION_READ_ACP);
        acl.grantPermission(new CanonicalGrantee("AWS member's ID"), Permission.PERMISSION_WRITE_ACP);
        String bucketNameForPolicy = publicBucket.getName();
        String policyJSON = "{\"Version\":\"2008-10-17\",\"Id\":\"EXAMPLE\",\"Statement\": [{\"Effect\":\"Allow\",\"Action\":[\"s3:GetObject*\"],\"Principal\":{\"AWS\": [\"*\"]},\"Resource\":\"arn:aws:s3:::" + bucketNameForPolicy + "/public/*\"}]}";
        s3Service.setBucketPolicy(bucketNameForPolicy, policyJSON);
        String policyDocument = s3Service.getBucketPolicy(bucketNameForPolicy);
        System.out.println(policyDocument);
        s3Service.deleteBucketPolicy(bucketNameForPolicy);
        S3Bucket privateBucket = new S3Bucket(awsCredentials.getAccessKey() + ".privateBucket");
        S3Object privateObject = new S3Object("privateObject.txt", "This object is private");
        s3Service.createBucket(privateBucket);
        s3Service.putObject(privateBucket, privateObject);
        Calendar cal = Calendar.getInstance();
        cal.add(12, 5);
        Date expiryDate = cal.getTime();
        String signedUrl = s3Service.createSignedGetUrl(privateBucket.getName(), privateObject.getKey(), expiryDate, false);
        System.out.println("Signed URL: " + signedUrl);
        S3Object largeFileObject = new S3Object(new File("/path/to/large/file"));
        ArrayList<StorageObject> objectsToUploadAsMultipart = new ArrayList<StorageObject>();
        objectsToUploadAsMultipart.add(largeFileObject);
        long maxSizeForAPartInBytes = 0x1400000L;
        MultipartUtils mpUtils = new MultipartUtils(maxSizeForAPartInBytes);
        mpUtils.uploadObjects(BUCKET_NAME, s3Service, objectsToUploadAsMultipart, null);
        String unrestrictedForm = S3Service.buildPostForm("public-bucket", "${filename}");
        String key = "uploads/images/pic.jpg";
        String[] inputFields = new String[]{"<input type=\"hidden\" name=\"acl\" value=\"public-read\">", "<input type=\"hidden\" name=\"Content-Type\" value=\"image/jpeg\">", "<input type=\"hidden\" name=\"success_action_redirect\" value=\"http://localhost/post_upload\">"};
        String[] conditions = new String[]{S3Service.generatePostPolicyCondition_Equality("bucket", BUCKET_NAME), S3Service.generatePostPolicyCondition_Equality("key", key), S3Service.generatePostPolicyCondition_Range(10240, 204800), S3Service.generatePostPolicyCondition_Equality("acl", "public-read"), S3Service.generatePostPolicyCondition_Equality("Content-Type", "image/jpeg"), S3Service.generatePostPolicyCondition_Equality("success_action_redirect", "http://localhost/post_upload")};
        cal = Calendar.getInstance();
        cal.add(10, 24);
        Date expiration = cal.getTime();
        String restrictedForm = S3Service.buildPostForm(BUCKET_NAME, key, awsCredentials, expiration, conditions, inputFields, null, true);
        s3Service.setRequesterPaysBucket(BUCKET_NAME, true);
        s3Service.setRequesterPaysBucket(BUCKET_NAME, false);
        s3Service.isRequesterPaysBucket(BUCKET_NAME);
        s3Service.setRequesterPaysEnabled(true);
        Map<String, Object> httpHeaders = null;
        long expirySecsAfterEpoch = System.currentTimeMillis() / 1000L + 300L;
        boolean isVirtualHost = false;
        boolean isHttpsUrl = false;
        boolean isDnsBucketNamingDisabled = false;
        String requesterPaysSignedGetUrl = s3Service.createSignedUrl("GET", BUCKET_NAME, "object-name", "x-amz-request-payer=requester", httpHeaders, expirySecsAfterEpoch, isVirtualHost, isHttpsUrl, isDnsBucketNamingDisabled);
        AWSDevPayCredentials devPayCredentials = new AWSDevPayCredentials("YOUR_AWS_ACCESSS_KEY", "YOUR_AWS_SECRET_KEY", "DEVPAY_USER_TOKEN", "DEVPAY_PRODUCT_TOKEN");
        RestS3Service devPayService = new RestS3Service(devPayCredentials);
        devPayService.listAllBuckets();
        cal = Calendar.getInstance();
        cal.add(12, 5);
        String signedDevPayUrl = devPayService.createSignedGetUrl("devpay-bucket-name", "devpay-object-name", cal.getTime());
    }
}

