/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.local;

import ch.cyberduck.binding.Proxy;
import ch.cyberduck.binding.application.NSWorkspace;
import ch.cyberduck.binding.foundation.NSDistributedNotificationCenter;
import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.ApplicationLauncher;
import ch.cyberduck.core.local.ApplicationQuitCallback;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;

public final class WorkspaceApplicationLauncher
implements ApplicationLauncher {
    private static final Logger log = Logger.getLogger(WorkspaceApplicationLauncher.class);
    private final NSWorkspace workspace = NSWorkspace.sharedWorkspace();
    private final Map<Application, ApplicationQuitCallback> registered = new HashMap<Application, ApplicationQuitCallback>();
    private final Proxy terminate = new Proxy(){

        public void terminated(NSNotification notification) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Received notification %s from workspace", notification.userInfo()));
            }
            if (notification.userInfo().objectForKey("NSApplicationBundleIdentifier") == null) {
                log.warn((Object)"Missing NSApplicationBundleIdentifier in notification dictionary");
                return;
            }
            Application application = new Application(notification.userInfo().objectForKey("NSApplicationBundleIdentifier").toString());
            if (WorkspaceApplicationLauncher.this.registered.containsKey(application)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Run quit callback for application %s", application));
                }
                ((ApplicationQuitCallback)WorkspaceApplicationLauncher.this.registered.get(application)).callback();
            }
        }
    };

    public void register(Application application, ApplicationQuitCallback callback) {
        this.workspace.notificationCenter().addObserver(this.terminate.id(), Foundation.selector((String)"terminated:"), "NSWorkspaceDidTerminateApplicationNotification", null);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Register application %s for callback %s", application, callback));
        }
        this.registered.put(application, callback);
    }

    protected void finalize() throws Throwable {
        try {
            log.warn((Object)String.format("Callback for %s is finalized", this.terminate));
            this.workspace.notificationCenter().removeObserver(this.terminate.id());
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open(Local file) {
        Class<NSWorkspace> clazz = NSWorkspace.class;
        synchronized (NSWorkspace.class) {
            if (!this.workspace.openFile(file.getAbsolute())) {
                log.warn((Object)String.format("Error opening file %s", file));
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open(Local file, Application application, ApplicationQuitCallback callback) {
        Class<NSWorkspace> clazz = NSWorkspace.class;
        synchronized (NSWorkspace.class) {
            String path = this.workspace.absolutePathForAppBundleWithIdentifier(application.getIdentifier());
            if (StringUtils.isNotBlank((CharSequence)path) && this.workspace.openFile(file.getAbsolute(), path)) {
                this.register(application, callback);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return true;
            }
            log.warn((Object)String.format("Error opening file %s with application %s", file, application));
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return false;
        }
    }

    public boolean open(Application application, String args) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bounce(Local file) {
        Class<NSWorkspace> clazz = NSWorkspace.class;
        synchronized (NSWorkspace.class) {
            NSDistributedNotificationCenter.defaultCenter().postNotification(NSNotification.notificationWithName((String)"com.apple.DownloadFileFinished", (String)file.getAbsolute()));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

