/*
 * Decompiled with CFR 0.152.
 */
package synapticloop.b2.request;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.B2AuthorizeAccountResponse;

public abstract class BaseB2Request {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseB2Request.class);
    protected static final String BASE_API_HOST = "https://api.backblazeb2.com";
    protected static final String BASE_API_VERSION = "/b2api/v1/";
    protected static final String BASE_API = "https://api.backblazeb2.com/b2api/v1/";
    public static final String VALUE_APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final String VALUE_UTF_8 = "UTF-8";
    private final Map<String, String> requestHeaders = new HashMap<String, String>();
    private final Map<String, String> requestParameters = new HashMap<String, String>();
    private final Map<String, Object> requestBodyData = new HashMap<String, Object>();
    private final CloseableHttpClient client;
    private final String url;

    protected BaseB2Request(CloseableHttpClient client, String url) {
        this.client = client;
        this.url = url;
    }

    protected BaseB2Request(CloseableHttpClient client, B2AuthorizeAccountResponse b2AuthorizeAccountResponse, String url) {
        this(client, b2AuthorizeAccountResponse, url, Collections.emptyMap());
    }

    protected BaseB2Request(CloseableHttpClient client, B2AuthorizeAccountResponse b2AuthorizeAccountResponse, String url, Map<String, String> headers) {
        this(client, url);
        this.addHeader("Authorization", b2AuthorizeAccountResponse.getAuthorizationToken());
    }

    protected void addHeader(String key, String value) {
        this.requestHeaders.put(key, value);
    }

    protected void addParameter(String key, String value) {
        this.requestParameters.put(key, value);
    }

    protected void addProperty(String key, Object value) {
        this.requestBodyData.put(key, value);
    }

    protected CloseableHttpResponse executeHead() throws B2ApiException, IOException {
        URI uri = this.buildUri();
        LOGGER.debug("HEAD request to URL '{}'", (Object)uri.toString());
        HttpHead httpHead = new HttpHead(uri);
        CloseableHttpResponse httpResponse = this.execute((HttpUriRequest)httpHead);
        switch (httpResponse.getStatusLine().getStatusCode()) {
            case 200: {
                return httpResponse;
            }
        }
        B2ApiException failure = new B2ApiException(EntityUtils.toString((HttpEntity)httpResponse.getEntity()), (Throwable)new HttpResponseException(httpResponse.getStatusLine().getStatusCode(), httpResponse.getStatusLine().getReasonPhrase()));
        if (httpResponse.containsHeader("Retry-After")) {
            throw failure.withRetry(Integer.valueOf(httpResponse.getFirstHeader("Retry-After").getValue()));
        }
        throw failure;
    }

    protected CloseableHttpResponse executeGet() throws B2ApiException, IOException {
        URI uri = this.buildUri();
        HttpGet httpGet = new HttpGet(uri);
        CloseableHttpResponse httpResponse = this.execute((HttpUriRequest)httpGet);
        switch (httpResponse.getStatusLine().getStatusCode()) {
            case 200: 
            case 206: {
                return httpResponse;
            }
        }
        B2ApiException failure = new B2ApiException(EntityUtils.toString((HttpEntity)httpResponse.getEntity()), (Throwable)new HttpResponseException(httpResponse.getStatusLine().getStatusCode(), httpResponse.getStatusLine().getReasonPhrase()));
        if (httpResponse.containsHeader("Retry-After")) {
            throw failure.withRetry(Integer.valueOf(httpResponse.getFirstHeader("Retry-After").getValue()));
        }
        throw failure;
    }

    protected CloseableHttpResponse executePost() throws B2ApiException, IOException {
        URI uri = this.buildUri();
        String postData = this.convertPostData();
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setEntity((HttpEntity)new StringEntity(postData, ContentType.APPLICATION_JSON));
        CloseableHttpResponse httpResponse = this.execute((HttpUriRequest)httpPost);
        switch (httpResponse.getStatusLine().getStatusCode()) {
            case 200: {
                return httpResponse;
            }
        }
        B2ApiException failure = new B2ApiException(EntityUtils.toString((HttpEntity)httpResponse.getEntity()), (Throwable)new HttpResponseException(httpResponse.getStatusLine().getStatusCode(), httpResponse.getStatusLine().getReasonPhrase()));
        if (httpResponse.containsHeader("Retry-After")) {
            throw failure.withRetry(Integer.valueOf(httpResponse.getFirstHeader("Retry-After").getValue()));
        }
        throw failure;
    }

    protected CloseableHttpResponse executePost(HttpEntity entity) throws B2ApiException, IOException {
        URI uri = this.buildUri();
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setEntity(entity);
        CloseableHttpResponse httpResponse = this.execute((HttpUriRequest)httpPost);
        switch (httpResponse.getStatusLine().getStatusCode()) {
            case 200: {
                return httpResponse;
            }
        }
        throw new B2ApiException(EntityUtils.toString((HttpEntity)httpResponse.getEntity()), (Throwable)new HttpResponseException(httpResponse.getStatusLine().getStatusCode(), httpResponse.getStatusLine().getReasonPhrase()));
    }

    protected String convertPostData() throws IOException {
        JSONObject jsonObject = new JSONObject();
        for (String key : this.requestBodyData.keySet()) {
            try {
                LOGGER.debug("Setting key '{}' to value '{}'", (Object)key, this.obfuscateData(key, this.requestBodyData.get(key)));
                jsonObject.put(key, this.requestBodyData.get(key));
            }
            catch (JSONException ex) {
                throw new IOException(ex);
            }
        }
        return jsonObject.toString();
    }

    protected URI buildUri() throws IOException {
        try {
            URIBuilder uriBuilder = new URIBuilder(this.url);
            for (String key : this.requestParameters.keySet()) {
                uriBuilder.addParameter(key, this.requestParameters.get(key));
            }
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    protected void setHeaders(HttpUriRequest request) throws B2ApiException {
        for (String headerKey : this.requestHeaders.keySet()) {
            if (!request.containsHeader(headerKey)) {
                String headerValue = this.requestHeaders.get(headerKey);
                if (!"Authorization".equalsIgnoreCase(headerKey)) {
                    LOGGER.trace("Setting header '" + headerKey + "' to '" + headerValue + "'.");
                } else {
                    LOGGER.trace("Setting header '" + headerKey + "' to '[redacted]'.");
                }
                request.setHeader(headerKey, headerValue);
                continue;
            }
            LOGGER.warn("Ignored duplicate header " + headerKey);
        }
    }

    protected CloseableHttpResponse execute(HttpUriRequest request) throws IOException, B2ApiException {
        this.setHeaders(request);
        LOGGER.debug("{} request to URL '{}'", (Object)request.getMethod(), (Object)request.getURI());
        CloseableHttpResponse httpResponse = this.client.execute(request);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received status code of: {}, for {} request to url '{}'", new Object[]{httpResponse.getStatusLine().getStatusCode(), request.getMethod(), request.getURI()});
        }
        return httpResponse;
    }

    private Object obfuscateData(String key, Object data) {
        if (LOGGER.isDebugEnabled() && "accountId".equals(key)) {
            return "[redacted]";
        }
        return data;
    }
}

