/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.SessionPoolFactory;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.threading.TransferBackgroundAction;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferAdapter;
import ch.cyberduck.core.transfer.TransferCallback;
import ch.cyberduck.core.transfer.TransferOptions;
import ch.cyberduck.core.transfer.TransferProgress;

public class BrowserTransferBackgroundAction
extends TransferBackgroundAction {
    private final Transfer transfer;
    private final TransferCallback callback;

    public BrowserTransferBackgroundAction(Controller controller, SessionPool pool, Transfer transfer, TransferCallback callback) {
        super(controller, pool, transfer.getType() == Transfer.Type.copy ? SessionPoolFactory.create(controller, pool.getCache(), transfer.getDestination()) : pool, new BrowserTransferAdapter(controller), transfer, new TransferOptions());
        this.transfer = transfer;
        this.callback = callback;
    }

    @Override
    public void finish() {
        if (this.transfer.isComplete()) {
            this.callback.complete(this.transfer);
        }
        super.finish();
    }

    private static class BrowserTransferAdapter
    extends TransferAdapter {
        private final ProgressListener listener;

        public BrowserTransferAdapter(ProgressListener listener) {
            this.listener = listener;
        }

        @Override
        public void transferDidProgress(Transfer transfer, TransferProgress status) {
            this.listener.message(status.getProgress());
            super.transferDidProgress(transfer, status);
        }
    }
}

