/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Lock;
import ch.cyberduck.core.features.Vault;

public class CryptoLockFeature<T>
implements Lock<T> {
    private final Session<?> session;
    private final Lock<T> delegate;
    private final Vault vault;

    public CryptoLockFeature(Session<?> session, Lock<T> delegate, Vault vault) {
        this.session = session;
        this.delegate = delegate;
        this.vault = vault;
    }

    public T lock(Path file) throws BackgroundException {
        return (T)this.delegate.lock(this.vault.encrypt(this.session, file));
    }

    public void unlock(Path file, T token) throws BackgroundException {
        this.delegate.unlock(this.vault.encrypt(this.session, file), token);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoLockFeature{");
        sb.append("delegate=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

