/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.http.signature;

import com.joyent.http.signature.CryptoException;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import java.util.Objects;

public final class KeyFingerprinter {
    private static Base64.Encoder b64Encoder = Base64.getEncoder().withoutPadding();
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();

    private KeyFingerprinter() {
    }

    public static String md5Fingerprint(KeyPair keyPair) {
        Objects.requireNonNull(keyPair);
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        byte[] encoded = SshEncoder.encode(keyPair.getPublic());
        md.update(encoded);
        byte[] digest = md.digest();
        return KeyFingerprinter.colonify(digest);
    }

    public static String sha256Fingerprint(KeyPair keyPair) {
        Objects.requireNonNull(keyPair);
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        byte[] encoded = SshEncoder.encode(keyPair.getPublic());
        md.update(encoded);
        byte[] digest = md.digest();
        return b64Encoder.encodeToString(digest);
    }

    public static boolean verifyFingerprint(KeyPair keyPair, String fingerprint) {
        Objects.requireNonNull(keyPair);
        Objects.requireNonNull(fingerprint);
        String md5Prefix = "MD5:";
        String sha256Prefix = "SHA256:";
        if (fingerprint.startsWith("MD5:")) {
            String expected = fingerprint.substring("MD5:".length());
            return expected.equals(KeyFingerprinter.md5Fingerprint(keyPair));
        }
        if (fingerprint.startsWith("SHA256:")) {
            String expected = fingerprint.substring("SHA256:".length());
            return expected.equals(KeyFingerprinter.sha256Fingerprint(keyPair));
        }
        return fingerprint.equals(KeyFingerprinter.md5Fingerprint(keyPair));
    }

    static String colonify(byte[] bytes) {
        Objects.requireNonNull(bytes, "byte array is null");
        if (bytes.length == 0) {
            return "";
        }
        char[] chars = new char[bytes.length * 3 - 1];
        int charPos = 0;
        for (int i = 0; i < bytes.length; ++i) {
            int val = bytes[i] & 0xFF;
            chars[charPos++] = HEX_CHARS[val >>> 4];
            chars[charPos++] = HEX_CHARS[val & 0xF];
            if (charPos + 1 >= chars.length) continue;
            chars[charPos++] = 58;
        }
        return new String(chars);
    }

    private static class SshEncoder {
        private SshEncoder() {
        }

        public static byte[] encode(PublicKey key) {
            if (key instanceof RSAPublicKey) {
                return SshEncoder.encode((RSAPublicKey)key);
            }
            if (key instanceof DSAPublicKey) {
                return SshEncoder.encode((DSAPublicKey)key);
            }
            if (key instanceof ECPublicKey) {
                return SshEncoder.encode((ECPublicKey)key);
            }
            throw new CryptoException("unknown public key type: " + key.getClass().getName());
        }

        public static byte[] encode(RSAPublicKey key) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            byte[] name = "ssh-rsa".getBytes(StandardCharsets.US_ASCII);
            SshEncoder.writeArray(name, buf);
            SshEncoder.writeArray(key.getPublicExponent().toByteArray(), buf);
            SshEncoder.writeArray(key.getModulus().toByteArray(), buf);
            return buf.toByteArray();
        }

        public static byte[] encode(DSAPublicKey key) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            byte[] name = "ssh-dss".getBytes(StandardCharsets.US_ASCII);
            SshEncoder.writeArray(name, buf);
            SshEncoder.writeArray(key.getParams().getP().toByteArray(), buf);
            SshEncoder.writeArray(key.getParams().getQ().toByteArray(), buf);
            SshEncoder.writeArray(key.getParams().getG().toByteArray(), buf);
            SshEncoder.writeArray(key.getY().toByteArray(), buf);
            return buf.toByteArray();
        }

        public static byte[] encode(ECPublicKey key) {
            int qLen;
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            int bitLength = key.getW().getAffineX().bitLength();
            String curveName = null;
            if (bitLength <= 256) {
                curveName = "nistp256";
                qLen = 65;
            } else if (bitLength <= 384) {
                curveName = "nistp384";
                qLen = 97;
            } else if (bitLength <= 521) {
                curveName = "nistp521";
                qLen = 133;
            } else {
                throw new CryptoException("ECDSA bit length unsupported: " + bitLength);
            }
            byte[] name = ("ecdsa-sha2-" + curveName).getBytes(StandardCharsets.US_ASCII);
            byte[] curve = curveName.getBytes(StandardCharsets.US_ASCII);
            SshEncoder.writeArray(name, buf);
            SshEncoder.writeArray(curve, buf);
            byte[] javaEncoding = key.getEncoded();
            byte[] q = new byte[qLen];
            System.arraycopy(javaEncoding, javaEncoding.length - qLen, q, 0, qLen);
            SshEncoder.writeArray(q, buf);
            return buf.toByteArray();
        }

        public static void writeArray(byte[] arr, ByteArrayOutputStream baos) {
            for (int shift = 24; shift >= 0; shift -= 8) {
                baos.write(arr.length >>> shift & 0xFF);
            }
            baos.write(arr, 0, arr.length);
        }
    }
}

