/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.azure;

import ch.cyberduck.core.AbstractProtocol;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.Scheme;
import com.microsoft.azure.storage.core.Base64;

public class AzureProtocol
extends AbstractProtocol {
    public String getName() {
        return "Azure";
    }

    public String getDefaultHostname() {
        return "storageaccount.blob.core.windows.net";
    }

    public String getUsernamePlaceholder() {
        return LocaleFactory.localizedString((String)"Storage Account Name", (String)"Azure");
    }

    public String getPasswordPlaceholder() {
        return LocaleFactory.localizedString((String)"Primary Access Key", (String)"Azure");
    }

    public boolean isHostnameConfigurable() {
        return true;
    }

    public boolean isPortConfigurable() {
        return false;
    }

    public String getIdentifier() {
        return "azure";
    }

    public String getDescription() {
        return "Windows Azure Storage";
    }

    public Scheme getScheme() {
        return Scheme.https;
    }

    public boolean validate(Credentials credentials, LoginOptions options) {
        if (super.validate(credentials, options)) {
            if (options.password) {
                return Base64.validateIsBase64String((String)credentials.getPassword());
            }
            return true;
        }
        return false;
    }
}

