/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractPaginationRequest;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class GetGroupMembersSpectraS3Request
extends AbstractPaginationRequest {
    private String groupId;
    private boolean lastPage;
    private String memberGroupId;
    private String memberUserId;
    private int pageLength;
    private int pageOffset;
    private String pageStartMarker;

    public GetGroupMembersSpectraS3Request withGroupId(UUID groupId) {
        this.groupId = groupId.toString();
        this.updateQueryParam("group_id", groupId);
        return this;
    }

    public GetGroupMembersSpectraS3Request withGroupId(String groupId) {
        this.groupId = groupId;
        this.updateQueryParam("group_id", groupId);
        return this;
    }

    public GetGroupMembersSpectraS3Request withLastPage(boolean lastPage) {
        this.lastPage = lastPage;
        if (this.lastPage) {
            this.getQueryParams().put("last_page", null);
        } else {
            this.getQueryParams().remove("last_page");
        }
        return this;
    }

    public GetGroupMembersSpectraS3Request withMemberGroupId(UUID memberGroupId) {
        this.memberGroupId = memberGroupId.toString();
        this.updateQueryParam("member_group_id", memberGroupId);
        return this;
    }

    public GetGroupMembersSpectraS3Request withMemberGroupId(String memberGroupId) {
        this.memberGroupId = memberGroupId;
        this.updateQueryParam("member_group_id", memberGroupId);
        return this;
    }

    public GetGroupMembersSpectraS3Request withMemberUserId(UUID memberUserId) {
        this.memberUserId = memberUserId.toString();
        this.updateQueryParam("member_user_id", memberUserId);
        return this;
    }

    public GetGroupMembersSpectraS3Request withMemberUserId(String memberUserId) {
        this.memberUserId = memberUserId;
        this.updateQueryParam("member_user_id", memberUserId);
        return this;
    }

    public GetGroupMembersSpectraS3Request withPageLength(int pageLength) {
        this.pageLength = pageLength;
        this.updateQueryParam("page_length", pageLength);
        return this;
    }

    public GetGroupMembersSpectraS3Request withPageOffset(int pageOffset) {
        this.pageOffset = pageOffset;
        this.updateQueryParam("page_offset", pageOffset);
        return this;
    }

    public GetGroupMembersSpectraS3Request withPageStartMarker(UUID pageStartMarker) {
        this.pageStartMarker = pageStartMarker.toString();
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetGroupMembersSpectraS3Request withPageStartMarker(String pageStartMarker) {
        this.pageStartMarker = pageStartMarker;
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.GET;
    }

    @Override
    public String getPath() {
        return "/_rest_/group_member";
    }

    public String getGroupId() {
        return this.groupId;
    }

    public boolean getLastPage() {
        return this.lastPage;
    }

    public String getMemberGroupId() {
        return this.memberGroupId;
    }

    public String getMemberUserId() {
        return this.memberUserId;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public String getPageStartMarker() {
        return this.pageStartMarker;
    }
}

