/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3EncryptionFeature;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3MetadataFeature;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.s3.S3StorageClassFeature;
import ch.cyberduck.core.s3.S3WriteFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.S3Object;

public class S3CopyFeature
implements Copy {
    private static final Logger log = Logger.getLogger(S3CopyFeature.class);
    private final S3Session session;
    private final PathContainerService containerService = new S3PathContainerService();
    private final S3AccessControlListFeature accessControlListFeature;

    public S3CopyFeature(S3Session session) {
        this(session, new S3AccessControlListFeature(session));
    }

    public S3CopyFeature(S3Session session, S3AccessControlListFeature accessControlListFeature) {
        this.session = session;
        this.accessControlListFeature = accessControlListFeature;
    }

    public Path copy(Path source, Path target, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        if (source.isFile() || source.isPlaceholder()) {
            if (null == status.getStorageClass()) {
                status.setStorageClass(new S3StorageClassFeature(this.session).getClass(source));
            }
            if (Encryption.Algorithm.NONE == status.getEncryption()) {
                status.setEncryption(new S3EncryptionFeature(this.session).getEncryption(source));
            }
            if (Acl.EMPTY == status.getAcl()) {
                try {
                    status.setAcl(this.accessControlListFeature.getPermission(source));
                }
                catch (AccessDeniedException | InteroperabilityException e) {
                    log.warn((Object)String.format("Ignore failure %s", e.getDetail()));
                }
            }
            S3Object destination = new S3WriteFeature(this.session).getDetails(target, status);
            destination.setAcl(this.accessControlListFeature.convert(status.getAcl()));
            destination.setBucketName(this.containerService.getContainer(target).getName());
            destination.replaceAllMetadata(new HashMap<String, String>(new S3MetadataFeature(this.session, this.accessControlListFeature).getMetadata(source)));
            String version = this.copy(source, destination, status);
            target.attributes().setVersionId(version);
        }
        return target;
    }

    protected String copy(Path source, S3Object destination, TransferStatus status) throws BackgroundException {
        try {
            Map stringObjectMap = ((RequestEntityRestStorageService)((Object)this.session.getClient())).copyVersionedObject(source.attributes().getVersionId(), this.containerService.getContainer(source).getName(), this.containerService.getKey(source), destination.getBucketName(), destination, false);
            Map complete = (Map)stringObjectMap.get("__complete__");
            return (String)complete.get("x-amz-version-id");
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Cannot copy {0}", e, source);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return false;
    }

    public boolean isSupported(Path source, Path target) {
        return !this.containerService.isContainer(source) && !this.containerService.isContainer(target);
    }

    public Copy withTarget(Session<?> session) {
        return this;
    }
}

