/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.auth;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.DisabledHostKeyCallback;
import ch.cyberduck.core.DisabledLoginCallback;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostParser;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.dav.DAVReadFeature;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;

public class AWSSessionCredentialsRetriever {
    private final TranscriptListener transcript;
    private final ProtocolFactory factory;
    private final String url;
    private final X509TrustManager trust;
    private final X509KeyManager key;

    public AWSSessionCredentialsRetriever(X509TrustManager trust, X509KeyManager key, TranscriptListener transcript, String url) {
        this(trust, key, ProtocolFactory.get(), transcript, url);
    }

    public AWSSessionCredentialsRetriever(X509TrustManager trust, X509KeyManager key, ProtocolFactory factory, TranscriptListener transcript, String url) {
        this.trust = trust;
        this.key = key;
        this.factory = factory;
        this.transcript = transcript;
        this.url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credentials get() throws BackgroundException {
        Host address = new HostParser(this.factory).get(this.url);
        Path access = new Path(PathNormalizer.normalize((String)address.getDefaultPath()), EnumSet.of(AbstractPath.Type.file));
        address.setDefaultPath(String.valueOf('/'));
        DAVSession connection = new DAVSession(address, this.trust, this.key);
        connection.withListener(this.transcript).open((HostKeyCallback)new DisabledHostKeyCallback(), (LoginCallback)new DisabledLoginCallback());
        InputStream in = new DAVReadFeature(connection).read(access, new TransferStatus(), (ConnectionCallback)new DisabledConnectionCallback());
        try {
            Credentials credentials = this.parse(in);
            connection.close();
            Credentials credentials2 = credentials;
            return credentials2;
        }
        finally {
            connection.removeListener(this.transcript);
        }
    }

    protected Credentials parse(InputStream in) throws BackgroundException {
        try {
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(in, "UTF-8"));
            reader.beginObject();
            String key = null;
            String secret = null;
            String token = null;
            while (reader.hasNext()) {
                String name = reader.nextName();
                String value = reader.nextString();
                switch (name) {
                    case "AccessKeyId": {
                        key = value;
                        break;
                    }
                    case "SecretAccessKey": {
                        secret = value;
                        break;
                    }
                    case "Token": {
                        token = value;
                    }
                }
            }
            reader.endObject();
            Credentials credentials = new Credentials(key, secret);
            if (StringUtils.isNotBlank(token)) {
                credentials.setToken(token);
            }
            return credentials;
        }
        catch (UnsupportedEncodingException e) {
            throw new DefaultIOExceptionMappingService().map((IOException)e);
        }
        catch (MalformedJsonException e) {
            throw new InteroperabilityException("Invalid JSON response", (Throwable)e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public String getUrl() {
        return this.url;
    }
}

