/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.googledrive.DriveExceptionMappingService;
import ch.cyberduck.core.googledrive.DriveFileidProvider;
import ch.cyberduck.core.googledrive.DriveHomeFinderService;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.http.HttpResponseExceptionMappingService;
import ch.cyberduck.core.preferences.PreferencesFactory;
import com.google.api.client.googleapis.batch.BatchRequest;
import com.google.api.client.googleapis.batch.json.JsonBatchCallback;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.http.HttpHeaders;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.http.client.HttpResponseException;
import org.apache.log4j.Logger;

public class DriveBatchDeleteFeature
implements Delete {
    private static final Logger log = Logger.getLogger(DriveBatchDeleteFeature.class);
    private final DriveSession session;
    private final DriveFileidProvider fileid;

    public DriveBatchDeleteFeature(DriveSession session, DriveFileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public void delete(List<Path> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        BatchRequest batch = ((Drive)this.session.getClient()).batch();
        ArrayList<BackgroundException> failures = new ArrayList<BackgroundException>();
        for (Path file : files) {
            try {
                if (DriveHomeFinderService.TEAM_DRIVES_NAME.equals((Object)file.getParent())) {
                    ((Drive)this.session.getClient()).teamdrives().delete(this.fileid.getFileid(file, (ListProgressListener)new DisabledListProgressListener())).queue(batch, new DeleteBatchCallback(file, failures, callback));
                    continue;
                }
                if (PreferencesFactory.get().getBoolean("googledrive.delete.trash")) {
                    File properties = new File();
                    properties.setTrashed(Boolean.valueOf(true));
                    ((Drive)this.session.getClient()).files().update(this.fileid.getFileid(file, (ListProgressListener)new DisabledListProgressListener()), properties).setSupportsTeamDrives(Boolean.valueOf(PreferencesFactory.get().getBoolean("googledrive.teamdrive.enable"))).queue(batch, new DeleteBatchCallback(file, failures, callback));
                    continue;
                }
                ((Drive)this.session.getClient()).files().delete(this.fileid.getFileid(file, (ListProgressListener)new DisabledListProgressListener())).setSupportsTeamDrives(Boolean.valueOf(PreferencesFactory.get().getBoolean("googledrive.teamdrive.enable"))).queue(batch, new DeleteBatchCallback(file, failures, callback));
            }
            catch (IOException e) {
                throw new DriveExceptionMappingService().map("Cannot delete {0}", e, file);
            }
        }
        if (!files.isEmpty()) {
            try {
                batch.execute();
            }
            catch (IOException e) {
                throw new DriveExceptionMappingService().map(e);
            }
            Iterator<Object> iterator = failures.iterator();
            if (iterator.hasNext()) {
                BackgroundException e = (BackgroundException)iterator.next();
                throw e;
            }
        }
    }

    public boolean isSupported(Path file) {
        return true;
    }

    public boolean isRecursive() {
        return false;
    }

    private static class DeleteBatchCallback<V>
    extends JsonBatchCallback<V> {
        private final Path file;
        private final List<BackgroundException> failures;
        private final Delete.Callback callback;

        public DeleteBatchCallback(Path file, List<BackgroundException> failures, Delete.Callback callback) {
            this.file = file;
            this.failures = failures;
            this.callback = callback;
        }

        public void onFailure(GoogleJsonError e, HttpHeaders responseHeaders) throws IOException {
            log.warn((Object)String.format("Failure deleting %s. %s", this.file, e.getMessage()));
            this.failures.add(new HttpResponseExceptionMappingService().map(new HttpResponseException(e.getCode(), e.getMessage())));
        }

        public void onSuccess(V aVoid, HttpHeaders responseHeaders) throws IOException {
            this.callback.delete(this.file);
        }
    }
}

