/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers;

import com.google.common.base.Preconditions;
import com.spectralogic.ds3client.helpers.ChecksumFunction;
import com.spectralogic.ds3client.helpers.Ds3ClientHelpers;
import com.spectralogic.ds3client.helpers.JobImpl;
import com.spectralogic.ds3client.helpers.MetadataAccess;
import com.spectralogic.ds3client.helpers.MetadataReceivedListener;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.MetaDataReceivedObserver;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.TransferStrategy;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.TransferStrategyBuilder;
import java.io.IOException;

class ReadJobImpl
extends JobImpl {
    private TransferStrategy transferStrategy;

    public ReadJobImpl(TransferStrategy transferStrategy) {
        this.transferStrategy = transferStrategy;
    }

    public ReadJobImpl(TransferStrategyBuilder transferStrategyBuilder) {
        super(transferStrategyBuilder);
    }

    @Override
    public void attachMetadataReceivedListener(MetadataReceivedListener listener) {
        this.checkRunning();
        this.eventDispatcher().attachMetadataReceivedEventObserver(new MetaDataReceivedObserver(listener));
    }

    @Override
    public void removeMetadataReceivedListener(MetadataReceivedListener listener) {
        this.checkRunning();
        this.eventDispatcher().removeMetadataReceivedEventObserver(new MetaDataReceivedObserver(listener));
    }

    @Override
    public Ds3ClientHelpers.Job withMetadata(MetadataAccess access) {
        throw new IllegalStateException("withMetadata method is not used with Read Jobs");
    }

    @Override
    public Ds3ClientHelpers.Job withChecksum(ChecksumFunction checksumFunction) {
        throw new IllegalStateException("withChecksum is not supported on Read Jobs");
    }

    @Override
    public void transfer(Ds3ClientHelpers.ObjectChannelBuilder channelBuilder) throws IOException {
        if (this.transferStrategy != null) {
            this.transfer();
            return;
        }
        super.transfer(channelBuilder);
        this.transferStrategy = this.transferStrategyBuilder().makeGetTransferStrategy();
        this.transfer();
    }

    @Override
    public void transfer() throws IOException {
        Preconditions.checkNotNull((Object)this.transferStrategy, (Object)"transferStrategy may not be null.");
        this.running = true;
        this.transferStrategy.transfer();
    }
}

