/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.AutoInspectMode;
import com.spectralogic.ds3client.models.ImportConflictResolutionMode;
import com.spectralogic.ds3client.models.Priority;
import com.spectralogic.ds3client.models.UnavailableMediaUsagePolicy;
import com.spectralogic.ds3client.networking.HttpVerb;

public class ModifyDataPathBackendSpectraS3Request
extends AbstractRequest {
    private boolean activated;
    private Integer autoActivateTimeoutInMins;
    private AutoInspectMode autoInspect;
    private ImportConflictResolutionMode defaultImportConflictResolutionMode;
    private Priority defaultVerifyDataAfterImport;
    private boolean defaultVerifyDataPriorToImport;
    private Integer partiallyVerifyLastPercentOfTapes;
    private UnavailableMediaUsagePolicy unavailableMediaPolicy;
    private int unavailablePoolMaxJobRetryInMins;
    private int unavailableTapePartitionMaxJobRetryInMins;

    public ModifyDataPathBackendSpectraS3Request withActivated(boolean activated) {
        this.activated = activated;
        this.updateQueryParam("activated", activated);
        return this;
    }

    public ModifyDataPathBackendSpectraS3Request withAutoActivateTimeoutInMins(Integer autoActivateTimeoutInMins) {
        this.autoActivateTimeoutInMins = autoActivateTimeoutInMins;
        this.updateQueryParam("auto_activate_timeout_in_mins", autoActivateTimeoutInMins);
        return this;
    }

    public ModifyDataPathBackendSpectraS3Request withAutoInspect(AutoInspectMode autoInspect) {
        this.autoInspect = autoInspect;
        this.updateQueryParam("auto_inspect", autoInspect);
        return this;
    }

    public ModifyDataPathBackendSpectraS3Request withDefaultImportConflictResolutionMode(ImportConflictResolutionMode defaultImportConflictResolutionMode) {
        this.defaultImportConflictResolutionMode = defaultImportConflictResolutionMode;
        this.updateQueryParam("default_import_conflict_resolution_mode", defaultImportConflictResolutionMode);
        return this;
    }

    public ModifyDataPathBackendSpectraS3Request withDefaultVerifyDataAfterImport(Priority defaultVerifyDataAfterImport) {
        this.defaultVerifyDataAfterImport = defaultVerifyDataAfterImport;
        this.updateQueryParam("default_verify_data_after_import", defaultVerifyDataAfterImport);
        return this;
    }

    public ModifyDataPathBackendSpectraS3Request withDefaultVerifyDataPriorToImport(boolean defaultVerifyDataPriorToImport) {
        this.defaultVerifyDataPriorToImport = defaultVerifyDataPriorToImport;
        this.updateQueryParam("default_verify_data_prior_to_import", defaultVerifyDataPriorToImport);
        return this;
    }

    public ModifyDataPathBackendSpectraS3Request withPartiallyVerifyLastPercentOfTapes(Integer partiallyVerifyLastPercentOfTapes) {
        this.partiallyVerifyLastPercentOfTapes = partiallyVerifyLastPercentOfTapes;
        this.updateQueryParam("partially_verify_last_percent_of_tapes", partiallyVerifyLastPercentOfTapes);
        return this;
    }

    public ModifyDataPathBackendSpectraS3Request withUnavailableMediaPolicy(UnavailableMediaUsagePolicy unavailableMediaPolicy) {
        this.unavailableMediaPolicy = unavailableMediaPolicy;
        this.updateQueryParam("unavailable_media_policy", unavailableMediaPolicy);
        return this;
    }

    public ModifyDataPathBackendSpectraS3Request withUnavailablePoolMaxJobRetryInMins(int unavailablePoolMaxJobRetryInMins) {
        this.unavailablePoolMaxJobRetryInMins = unavailablePoolMaxJobRetryInMins;
        this.updateQueryParam("unavailable_pool_max_job_retry_in_mins", unavailablePoolMaxJobRetryInMins);
        return this;
    }

    public ModifyDataPathBackendSpectraS3Request withUnavailableTapePartitionMaxJobRetryInMins(int unavailableTapePartitionMaxJobRetryInMins) {
        this.unavailableTapePartitionMaxJobRetryInMins = unavailableTapePartitionMaxJobRetryInMins;
        this.updateQueryParam("unavailable_tape_partition_max_job_retry_in_mins", unavailableTapePartitionMaxJobRetryInMins);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/data_path_backend";
    }

    public boolean getActivated() {
        return this.activated;
    }

    public Integer getAutoActivateTimeoutInMins() {
        return this.autoActivateTimeoutInMins;
    }

    public AutoInspectMode getAutoInspect() {
        return this.autoInspect;
    }

    public ImportConflictResolutionMode getDefaultImportConflictResolutionMode() {
        return this.defaultImportConflictResolutionMode;
    }

    public Priority getDefaultVerifyDataAfterImport() {
        return this.defaultVerifyDataAfterImport;
    }

    public boolean getDefaultVerifyDataPriorToImport() {
        return this.defaultVerifyDataPriorToImport;
    }

    public Integer getPartiallyVerifyLastPercentOfTapes() {
        return this.partiallyVerifyLastPercentOfTapes;
    }

    public UnavailableMediaUsagePolicy getUnavailableMediaPolicy() {
        return this.unavailableMediaPolicy;
    }

    public int getUnavailablePoolMaxJobRetryInMins() {
        return this.unavailablePoolMaxJobRetryInMins;
    }

    public int getUnavailableTapePartitionMaxJobRetryInMins() {
        return this.unavailableTapePartitionMaxJobRetryInMins;
    }
}

