/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.networking.HttpVerb;

public class ListMultiPartUploadsRequest
extends AbstractRequest {
    private final String bucketName;
    private String delimiter;
    private String keyMarker;
    private int maxUploads;
    private String prefix;
    private String uploadIdMarker;

    public ListMultiPartUploadsRequest(String bucketName) {
        this.bucketName = bucketName;
        this.getQueryParams().put("uploads", null);
    }

    public ListMultiPartUploadsRequest withDelimiter(String delimiter) {
        this.delimiter = delimiter;
        this.updateQueryParam("delimiter", delimiter);
        return this;
    }

    public ListMultiPartUploadsRequest withKeyMarker(String keyMarker) {
        this.keyMarker = keyMarker;
        this.updateQueryParam("key_marker", keyMarker);
        return this;
    }

    public ListMultiPartUploadsRequest withMaxUploads(int maxUploads) {
        this.maxUploads = maxUploads;
        this.updateQueryParam("max_uploads", maxUploads);
        return this;
    }

    public ListMultiPartUploadsRequest withPrefix(String prefix) {
        this.prefix = prefix;
        this.updateQueryParam("prefix", prefix);
        return this;
    }

    public ListMultiPartUploadsRequest withUploadIdMarker(String uploadIdMarker) {
        this.uploadIdMarker = uploadIdMarker;
        this.updateQueryParam("upload_id_marker", uploadIdMarker);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.GET;
    }

    @Override
    public String getPath() {
        return "/" + this.bucketName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getKeyMarker() {
        return this.keyMarker;
    }

    public int getMaxUploads() {
        return this.maxUploads;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getUploadIdMarker() {
        return this.uploadIdMarker;
    }
}

