/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.networking.HttpVerb;

public class DeleteObjectRequest
extends AbstractRequest {
    private final String bucketName;
    private final String objectName;
    private boolean rollBack;

    public DeleteObjectRequest(String bucketName, String objectName) {
        this.bucketName = bucketName;
        this.objectName = objectName;
    }

    public DeleteObjectRequest withRollBack(boolean rollBack) {
        this.rollBack = rollBack;
        if (this.rollBack) {
            this.getQueryParams().put("roll_back", null);
        } else {
            this.getQueryParams().remove("roll_back");
        }
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.DELETE;
    }

    @Override
    public String getPath() {
        return "/" + this.bucketName + "/" + this.objectName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean getRollBack() {
        return this.rollBack;
    }
}

