/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.date.InvalidDateException;
import ch.cyberduck.core.date.RFC1123DateFormatter;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.openstack.SwiftExceptionMappingService;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.model.ContainerInfo;
import ch.iterate.openstack.swift.model.ObjectMetadata;
import ch.iterate.openstack.swift.model.Region;
import ch.iterate.openstack.swift.model.StorageObject;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SwiftAttributesFinderFeature
implements AttributesFinder {
    private static final Logger log = Logger.getLogger(SwiftAttributesFinderFeature.class);
    private final SwiftSession session;
    private final PathContainerService containerService = new PathContainerService();
    private final RFC1123DateFormatter dateParser = new RFC1123DateFormatter();
    private final SwiftRegionService regionService;

    public SwiftAttributesFinderFeature(SwiftSession session) {
        this(session, new SwiftRegionService(session));
    }

    public SwiftAttributesFinderFeature(SwiftSession session, SwiftRegionService regionService) {
        this.session = session;
        this.regionService = regionService;
    }

    public PathAttributes find(Path file) throws BackgroundException {
        if (file.isRoot()) {
            return PathAttributes.EMPTY;
        }
        Region region = this.regionService.lookup(file);
        try {
            if (this.containerService.isContainer(file)) {
                ContainerInfo info = ((Client)this.session.getClient()).getContainerInfo(region, this.containerService.getContainer(file).getName());
                PathAttributes attributes = new PathAttributes();
                attributes.setSize(info.getTotalSize());
                attributes.setRegion(info.getRegion().getRegionId());
                return attributes;
            }
            ObjectMetadata metadata = ((Client)this.session.getClient()).getObjectMetaData(region, this.containerService.getContainer(file).getName(), this.containerService.getKey(file));
            if (file.isDirectory() && !StringUtils.equals((CharSequence)"application/directory", (CharSequence)metadata.getMimeType())) {
                throw new NotfoundException(String.format("Path %s is file", file.getAbsolute()));
            }
            if (file.isFile() && StringUtils.equals((CharSequence)"application/directory", (CharSequence)metadata.getMimeType())) {
                throw new NotfoundException(String.format("Path %s is directory", file.getAbsolute()));
            }
            return this.toAttributes(metadata);
        }
        catch (GenericException e) {
            throw new SwiftExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Failure to read attributes of {0}", (Throwable)e, file);
        }
    }

    protected PathAttributes toAttributes(StorageObject object) {
        PathAttributes attributes = new PathAttributes();
        if (StringUtils.isNotBlank((CharSequence)object.getMd5sum())) {
            attributes.setChecksum(Checksum.parse((String)object.getMd5sum()));
        }
        attributes.setSize(object.getSize().longValue());
        String lastModified = object.getLastModified();
        if (lastModified != null) {
            try {
                attributes.setModificationDate(this.dateParser.parse(lastModified).getTime());
            }
            catch (InvalidDateException e) {
                log.warn((Object)String.format("%s is not ISO 8601 format %s", lastModified, e.getMessage()));
            }
        }
        return attributes;
    }

    protected PathAttributes toAttributes(ObjectMetadata metadata) {
        PathAttributes attributes = new PathAttributes();
        attributes.setSize(Long.valueOf(metadata.getContentLength()).longValue());
        try {
            attributes.setModificationDate(this.dateParser.parse(metadata.getLastModified()).getTime());
        }
        catch (InvalidDateException e) {
            log.warn((Object)String.format("%s is not RFC 1123 format %s", metadata.getLastModified(), e.getMessage()));
        }
        if (StringUtils.isNotBlank((CharSequence)metadata.getETag())) {
            String etag = StringUtils.removePattern((String)metadata.getETag(), (String)"\"");
            attributes.setETag(etag);
            if (metadata.getMetaData().containsKey("X-Static-Large-Object")) {
                attributes.setChecksum(Checksum.NONE);
            } else {
                attributes.setChecksum(Checksum.parse((String)etag));
            }
        }
        return attributes;
    }

    public AttributesFinder withCache(Cache<Path> cache) {
        return this;
    }
}

