/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.ClosedChannelException;
import org.globus.common.CoGProperties;
import org.globus.gsi.gssapi.net.impl.GSIGssInputStream;
import org.globus.gsi.gssapi.net.impl.GSIGssOutputStream;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.irods.jargon.core.connection.AbstractIRODSMidLevelProtocol;
import org.irods.jargon.core.connection.AuthMechanism;
import org.irods.jargon.core.connection.GSIIRODSAccount;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.StartupResponseData;
import org.irods.jargon.core.connection.auth.AuthResponse;
import org.irods.jargon.core.exception.AuthenticationException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.protovalues.RequestTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GSIAuth
extends AuthMechanism {
    public static final Logger log = LoggerFactory.getLogger(GSIAuth.class);
    private static final int GSI_AUTH_REQUEST_AN = 711;

    GSIAuth() {
    }

    void sendGSIPassword(GSIIRODSAccount irodsAccount, AbstractIRODSMidLevelProtocol irodsCommands) throws JargonException {
        log.info("sendGSIPassword()");
        if (irodsAccount == null) {
            throw new JargonException("irods account is null");
        }
        if (irodsCommands == null) {
            throw new IllegalArgumentException("null irodsCommands");
        }
        log.debug("sending gsi auth request after startup...");
        try {
            irodsCommands.sendHeader(RequestTypes.RODS_API_REQ.getRequestType(), 0, 0, 0L, 711);
            irodsCommands.getIrodsConnection().flush();
        }
        catch (ClosedChannelException e) {
            log.error("closed channel", (Throwable)e);
            e.printStackTrace();
            throw new JargonException(e);
        }
        catch (InterruptedIOException e) {
            log.error("interrupted io", (Throwable)e);
            e.printStackTrace();
            throw new JargonException(e);
        }
        catch (IOException e) {
            log.error("io exception", (Throwable)e);
            e.printStackTrace();
            throw new JargonException(e);
        }
        log.debug("reading iRODS response to gsi auth request, extracting server DN...");
        String serverDn = irodsCommands.readMessage(false).getTag("ServerDN").getStringValue();
        log.debug("serverDN:{}", (Object)serverDn);
        irodsAccount.setServerDistinguishedName(serverDn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    AbstractIRODSMidLevelProtocol sendGSIAuth(GSIIRODSAccount irodsAccount, AbstractIRODSMidLevelProtocol irodsCommands) throws AuthenticationException, JargonException {
        AbstractIRODSMidLevelProtocol abstractIRODSMidLevelProtocol;
        log.info("sendGSIAuth()");
        GSIIRODSAccount originalIrodsAccount = irodsAccount;
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        if (irodsAccount.getGSSCredential() == null) {
            throw new IllegalArgumentException("null gssCredential");
        }
        if (irodsCommands == null) {
            throw new IllegalArgumentException("null irodsCommands");
        }
        this.sendGSIPassword(irodsAccount, irodsCommands);
        CoGProperties cog = null;
        String defaultCA = null;
        String caLocations = irodsAccount.getCertificateAuthority();
        ExtendedGSSManager manager = (ExtendedGSSManager)ExtendedGSSManager.getInstance();
        GSIGssOutputStream gssout = null;
        GSIGssInputStream gssin = null;
        try {
            if (caLocations != null && caLocations.length() > 0) {
                cog = CoGProperties.getDefault();
                defaultCA = cog.getCaCertLocations();
                cog.setCaCertLocations(caLocations);
            }
            GSSContext context = manager.createContext(null, null, irodsAccount.getGSSCredential(), 0);
            context.requestCredDeleg(false);
            context.requestMutualAuth(true);
            gssout = new GSIGssOutputStream(irodsCommands.getIrodsConnection().getIrodsOutputStream(), context);
            gssin = new GSIGssInputStream(irodsCommands.getIrodsConnection().getIrodsInputStream(), context);
            byte[] inToken = new byte[]{};
            byte[] outToken = null;
            while (!context.isEstablished()) {
                outToken = context.initSecContext(inToken, 0, inToken.length);
                if (outToken != null) {
                    gssout.writeToken(outToken);
                }
                if (context.isEstablished()) continue;
                inToken = gssin.readHandshakeToken();
            }
            AuthResponse response = new AuthResponse();
            response.setAuthenticatingIRODSAccount(originalIrodsAccount);
            response.setAuthenticatedIRODSAccount(irodsAccount);
            irodsCommands.setAuthResponse(response);
            abstractIRODSMidLevelProtocol = irodsCommands;
            if (defaultCA == null) return abstractIRODSMidLevelProtocol;
        }
        catch (GSSException e) {
            try {
                AuthenticationException gsiException = null;
                String message = e.getMessage();
                if (message.indexOf("Invalid buffer") >= 0) {
                    gsiException = new AuthenticationException("GSI Authentication Failed - Invalid Proxy File");
                    gsiException.initCause(e);
                    throw gsiException;
                }
                if (message.indexOf("Unknown CA") >= 0) {
                    gsiException = new AuthenticationException("GSI Authentication Failed - Cannot find Certificate Authority (CA)");
                    gsiException.initCause(e);
                    throw gsiException;
                }
                gsiException = new AuthenticationException("GSI Authentication Failed");
                gsiException.initCause(e);
                throw gsiException;
                catch (Throwable e2) {
                    SecurityException exception = new SecurityException("GSI Authentication Failed");
                    exception.initCause(e2);
                    throw exception;
                }
            }
            catch (Throwable throwable) {
                if (defaultCA == null) throw throwable;
                cog.setCaCertLocations(defaultCA);
                throw throwable;
            }
        }
        cog.setCaCertLocations(defaultCA);
        return abstractIRODSMidLevelProtocol;
    }

    @Override
    protected AbstractIRODSMidLevelProtocol processAuthenticationAfterStartup(IRODSAccount irodsAccount, AbstractIRODSMidLevelProtocol irodsCommands, StartupResponseData startupResponseData) throws AuthenticationException, JargonException {
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        log.info("processAuthenticationAfterStartup()..checking if GSIIRODSAccount and validating credential");
        if (!(irodsAccount instanceof GSIIRODSAccount)) {
            throw new IllegalArgumentException("irodsAccount should be an instance of GSIIRODSAccount");
        }
        GSIIRODSAccount gsiIRODSAccount = (GSIIRODSAccount)irodsAccount;
        log.info("have credential, check if valid...");
        try {
            if (gsiIRODSAccount.getGSSCredential().getRemainingLifetime() <= 0) {
                throw new AuthenticationException("gss credentials are expired");
            }
        }
        catch (GSSException e) {
            log.error("GSSException processing credential");
            throw new JargonException("gss exception processing credential", e);
        }
        log.info("all valid...send GSI auth to iRODS...");
        return this.sendGSIAuth(gsiIRODSAccount, irodsCommands);
    }
}

