/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.preferences;

import ch.cyberduck.binding.foundation.FoundationKitFunctionsLibrary;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSBundle;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSEnumerator;
import ch.cyberduck.binding.foundation.NSLocale;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.binding.foundation.NSString;
import ch.cyberduck.binding.foundation.NSUserDefaults;
import ch.cyberduck.core.Factory;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.cache.LRUCache;
import ch.cyberduck.core.local.FinderLocal;
import ch.cyberduck.core.preferences.BundleApplicationResourcesFinder;
import ch.cyberduck.core.preferences.DefaultPreferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;

public class UserDefaultsPreferences
extends DefaultPreferences {
    private static final Logger log = Logger.getLogger(UserDefaultsPreferences.class);
    private final NSBundle bundle = new BundleApplicationResourcesFinder().bundle();
    private final LRUCache<String, String> cache = LRUCache.usingLoader(this::loadProperty, (long)PreferencesFactory.get().getLong("preferences.cache.size"));
    private static final String MISSING_PROPERTY = String.valueOf(-1);
    private NSUserDefaults store;

    public String getDefault(String property) {
        String value = super.getDefault(property);
        if (null == value) {
            NSObject plist = this.bundle.infoDictionary().objectForKey(property);
            if (null == plist) {
                log.warn((Object)String.format("No default value for property %s", property));
                return null;
            }
            return plist.toString();
        }
        return value;
    }

    public String getProperty(String property) {
        String value = (String)this.cache.get((Object)property);
        return StringUtils.equals((CharSequence)MISSING_PROPERTY, (CharSequence)value) ? null : value;
    }

    private String loadProperty(String property) {
        NSObject value = this.store.objectForKey(property);
        if (null == value) {
            String d = this.getDefault(property);
            return null == d ? MISSING_PROPERTY : d;
        }
        if (value.isKindOfClass(Rococoa.createClass((String)"NSString", NSString._Class.class))) {
            return value.toString();
        }
        if (value.isKindOfClass(Rococoa.createClass((String)"NSArray", NSArray._Class.class))) {
            return StringUtils.join(this.toList((NSArray)Rococoa.cast((ObjCObject)value, NSArray.class)), (String)" ");
        }
        log.warn((Object)String.format("Unknown type for property %s", property));
        return value.toString();
    }

    public void setProperty(String property, String value) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Set property %s for key %s", value, property));
        }
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.store.setObjectForKey((NSObject)NSString.stringWithString((String)value), property);
            this.cache.put((Object)property, (Object)value);
        } else {
            this.deleteProperty(property);
        }
    }

    public void setDefault(String property, String value) {
        super.setDefault(property, value);
        this.cache.remove((Object)property);
    }

    public void setProperty(String property, List<String> value) {
        this.store.setObjectForKey((NSObject)NSArray.arrayWithObjects((String[])value.toArray(new String[value.size()])), property);
    }

    public void deleteProperty(String property) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Delete property %s", property));
        }
        this.store.removeObjectForKey(property);
        this.cache.remove((Object)property);
    }

    public void load() {
        this.store = NSUserDefaults.standardUserDefaults();
    }

    protected void post() {
        this._init("browser.view.autoexpand.useDelay");
        this._init("browser.view.autoexpand.delay");
        this._init("connection.retry");
        this._init("connection.retry.delay");
        this._init("connection.timeout.seconds");
        this._init("bookmark.icon.size");
        super.post();
    }

    protected void setDefaults() {
        super.setDefaults();
        this.setDefault("tmp.dir", FoundationKitFunctionsLibrary.NSTemporaryDirectory());
        if (null != this.bundle) {
            if (this.bundle.objectForInfoDictionaryKey("CFBundleName") != null) {
                this.setDefault("application.name", this.bundle.objectForInfoDictionaryKey("CFBundleName").toString());
            }
            if (this.bundle.objectForInfoDictionaryKey("NSHumanReadableCopyright") != null) {
                this.setDefault("application.copyright", this.bundle.objectForInfoDictionaryKey("NSHumanReadableCopyright").toString());
            }
            if (this.bundle.objectForInfoDictionaryKey("CFBundleIdentifier") != null) {
                this.setDefault("application.identifier", this.bundle.objectForInfoDictionaryKey("CFBundleIdentifier").toString());
            }
            if (this.bundle.objectForInfoDictionaryKey("CFBundleShortVersionString") != null) {
                this.setDefault("application.version", this.bundle.objectForInfoDictionaryKey("CFBundleShortVersionString").toString());
            }
            if (this.bundle.objectForInfoDictionaryKey("CFBundleVersion") != null) {
                this.setDefault("application.revision", this.bundle.objectForInfoDictionaryKey("CFBundleVersion").toString());
            }
            this.setDefault("application.receipt.path", String.format("%s/Contents/_MASReceipt", this.bundle.bundlePath()));
        }
        this.setDefault("update.feed.release", "https://version.cyberduck.io/changelog.rss");
        this.setDefault("update.feed.beta", "https://version.cyberduck.io/beta/changelog.rss");
        this.setDefault("update.feed.nightly", "https://version.cyberduck.io/nightly/changelog.rss");
        if (!StringUtils.startsWith((CharSequence)this.getProperty("SUFeedURL"), (CharSequence)Scheme.https.name())) {
            this.deleteProperty("SUFeedURL");
            this.save();
        }
        this.setDefault("bookmark.import.filezilla.location", "~/.config/filezilla/sitemanager.xml");
        this.setDefault("bookmark.import.fetch.location", "~/Library/Preferences/com.fetchsoftworks.Fetch.Shortcuts.plist");
        this.setDefault("bookmark.import.flow.location", "~/Library/Application Support/Flow/Bookmarks.plist");
        this.setDefault("bookmark.import.interarchy.location", "~/Library/Application Support/Interarchy/Bookmarks.plist");
        this.setDefault("bookmark.import.transmit.location", "~/Library/Preferences/com.panic.Transmit.plist");
        this.setDefault("bookmark.import.transmit4.location", "~/Library/Application Support/Transmit/Favorites/Favorites.xml");
        this.setDefault("bookmark.import.crossftp.location", "~/.crossftp/sites.xml");
        this.setDefault("bookmark.import.fireftp.location", "~/Library/Application Support/Firefox/Profiles");
        this.setDefault("bookmark.import.expandrive3.location", "~/Library/Application Support/ExpanDrive/favorites.js");
        this.setDefault("bookmark.import.expandrive4.location", "~/Library/Application Support/ExpanDrive/expandrive4.favorites.js");
        this.setDefault("bookmark.import.expandrive5.location", "~/Library/Application Support/ExpanDrive/expandrive5.favorites.js");
        this.setDefault("bookmark.import.expandrive6.location", "~/Library/Application Support/ExpanDrive/expandrive6.favorites.js");
        if (new FinderLocal("~/Downloads").exists()) {
            this.setDefault("queue.download.folder", "~/Downloads");
        } else {
            this.setDefault("queue.download.folder", "~/Desktop");
        }
        this.setDefault("browser.filesize.decimal", String.valueOf(!Factory.Platform.osversion.matches("10\\.5.*")));
        this.setDefault("connection.ssl.keystore.type", "KeychainStore");
        this.setDefault("connection.ssl.keystore.provider", "Apple");
        this.setDefault("network.interface.blacklist", "awdl0 utun0");
        this.setDefault("browser.window.tabbing.identifier", "browser.window.tabbing.identifier");
        this.setDefault("queue.window.tabbing.identifier", "browser.window.tabbing.identifier");
    }

    private void _init(String property) {
        if (null == this.store.objectForKey(property)) {
            this.setProperty(property, this.getDefault(property));
        }
    }

    public void save() {
        this.store.synchronize();
    }

    public String locale() {
        List<String> languages;
        NSObject value = this.store.objectForKey("AppleLanguages");
        if (null == value) {
            return super.locale();
        }
        if (value.isKindOfClass(Rococoa.createClass((String)"NSArray", NSArray._Class.class)) && null != (languages = this.toList((NSArray)Rococoa.cast((ObjCObject)value, NSArray.class)))) {
            return languages.iterator().next();
        }
        return super.locale();
    }

    public List<String> applicationLocales() {
        return this.toList(this.bundle.localizations());
    }

    public List<String> systemLocales() {
        return this.toList(NSLocale.preferredLanguages());
    }

    private List<String> toList(NSArray array) {
        NSObject next;
        if (null == array) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        NSEnumerator ordered = array.objectEnumerator();
        while ((next = ordered.nextObject()) != null) {
            list.add(next.toString());
        }
        return list;
    }

    private Map<String, String> toMap(NSDictionary dictionary) {
        NSObject key;
        if (null == dictionary) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        NSEnumerator keys = dictionary.keyEnumerator();
        while ((key = keys.nextObject()) != null) {
            map.put(key.toString(), dictionary.objectForKey(key.toString()).toString());
        }
        return map;
    }
}

