/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.onedrive.OneDriveExceptionMappingService;
import ch.cyberduck.core.onedrive.OneDriveSession;
import ch.cyberduck.core.onedrive.features.OneDriveDeleteFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.util.Collections;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.log4j.Logger;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveCopyOperation;
import org.nuxeo.onedrive.client.OneDriveFolder;
import org.nuxeo.onedrive.client.OneDriveItem;

public class OneDriveCopyFeature
implements Copy {
    private static final Logger logger = Logger.getLogger(OneDriveCopyFeature.class);
    private final OneDriveSession session;
    private final PathContainerService containerService = new PathContainerService();

    public OneDriveCopyFeature(OneDriveSession session) {
        this.session = session;
    }

    public Path copy(Path source, Path target, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        OneDriveCopyOperation copyOperation = new OneDriveCopyOperation();
        if (!StringUtils.equals((CharSequence)source.getName(), (CharSequence)target.getName())) {
            copyOperation.rename(target.getName());
        }
        if (status.isExists()) {
            new OneDriveDeleteFeature(this.session).delete(Collections.singletonList(target), (PasswordCallback)callback, (Delete.Callback)new Delete.DisabledCallback());
        }
        OneDriveFolder targetItem = this.session.toFolder(target.getParent());
        copyOperation.copy(targetItem);
        OneDriveItem item = this.session.toItem(source);
        try {
            item.copy(copyOperation).await(statusObject -> logger.info((Object)String.format("Copy Progress Operation %s progress %f status %s", statusObject.getOperation(), Float.valueOf(statusObject.getPercentage()), statusObject.getStatus())));
            return target;
        }
        catch (OneDriveAPIException e) {
            throw new OneDriveExceptionMappingService().map("Cannot copy {0}", e, source);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot copy {0}", (Throwable)e, source);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }

    public boolean isSupported(Path source, Path target) {
        if (this.containerService.isContainer(source)) {
            return false;
        }
        if (!this.containerService.getContainer(source).equals((Object)this.containerService.getContainer(target))) {
            return false;
        }
        return !source.getType().contains(AbstractPath.Type.shared);
    }

    public Copy withTarget(Session<?> session) {
        return this;
    }
}

