/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.http;

import com.fasterxml.uuid.EthernetAddress;
import com.fasterxml.uuid.Generators;
import com.fasterxml.uuid.impl.TimeBasedGenerator;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.slf4j.MDC;

public class RequestIdInterceptor
implements HttpRequestInterceptor {
    private static final TimeBasedGenerator TIME_BASED_GENERATOR;
    public static final String MDC_REQUEST_ID_STRING = "mantaRequestId";

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        UUID id = TIME_BASED_GENERATOR.generate();
        String requestId = id.toString();
        BasicHeader idHeader = new BasicHeader("x-request-id", requestId);
        request.addHeader((Header)idHeader);
        MDC.put((String)MDC_REQUEST_ID_STRING, (String)requestId);
    }

    static {
        Random nonBlockingRandomness;
        try {
            nonBlockingRandomness = SecureRandom.getInstance("NativePRNGNonBlocking", "SUN");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            nonBlockingRandomness = new Random(System.nanoTime());
        }
        EthernetAddress ethernetAddress = EthernetAddress.constructMulticastAddress((Random)nonBlockingRandomness);
        TIME_BASED_GENERATOR = Generators.timeBasedGenerator((EthernetAddress)ethernetAddress);
    }
}

