/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.shared.DefaultHomeFinderService;
import java.util.EnumSet;

public class S3HomeFinderService
extends DefaultHomeFinderService {
    private final PathContainerService containerService = new S3PathContainerService();

    public S3HomeFinderService(Session session) {
        super(session);
    }

    public Path find() throws BackgroundException {
        Path home = super.find();
        if (this.containerService.isContainer(home)) {
            return new Path(home.getAbsolute(), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory));
        }
        return home;
    }

    public Path find(Path root, String path) {
        Path home = super.find(root, path);
        if (this.containerService.isContainer(home)) {
            return new Path(home.getAbsolute(), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory));
        }
        return home;
    }
}

