/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.impl;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.CacheReference;
import ch.cyberduck.core.DefaultPathPredicate;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.RandomStringService;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.UUIDRandomStringService;
import ch.cyberduck.core.cryptomator.ContentReader;
import ch.cyberduck.core.cryptomator.CryptoVault;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.Map;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CryptoDirectoryProvider {
    private static final Logger log = Logger.getLogger(CryptoDirectoryProvider.class);
    private static final String DATA_DIR_NAME = "d";
    private static final String ROOT_DIR_ID = "";
    private final Path dataRoot;
    private final Path home;
    private final CryptoVault cryptomator;
    private final RandomStringService random = new UUIDRandomStringService();
    private final Map<CacheReference<Path>, String> cache = new LRUMap(PreferencesFactory.get().getInteger("browser.cache.size"));

    public CryptoDirectoryProvider(Path vault, CryptoVault cryptomator) {
        this.home = vault;
        this.dataRoot = new Path(vault, DATA_DIR_NAME, vault.getType());
        this.cryptomator = cryptomator;
    }

    public String toEncrypted(Session<?> session, String directoryId, String filename, EnumSet<AbstractPath.Type> type) throws BackgroundException {
        String prefix = type.contains(AbstractPath.Type.directory) ? "0" : ROOT_DIR_ID;
        String ciphertextName = String.format("%s%s", prefix, this.cryptomator.getCryptor().fileNameCryptor().encryptFilename(filename, (byte[][])new byte[][]{directoryId.getBytes(StandardCharsets.UTF_8)}));
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Encrypted filename %s to %s", filename, ciphertextName));
        }
        return this.cryptomator.getFilenameProvider().deflate(session, ciphertextName);
    }

    public Path toEncrypted(Session<?> session, String directoryId, Path directory) throws BackgroundException {
        if (!directory.isDirectory()) {
            throw new NotfoundException(directory.getAbsolute());
        }
        if (new SimplePathPredicate(directory).test(this.home) || directory.isChild(this.home)) {
            PathAttributes attributes = new PathAttributes(directory.attributes());
            if (new SimplePathPredicate(directory).test(this.home)) {
                attributes.withVersionId((String)null);
            }
            String id = this.toDirectoryId(session, directory, directoryId);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Use directory ID '%s' for folder %s", id, directory));
            }
            attributes.setDirectoryId(id);
            attributes.setDecrypted(directory);
            String directoryIdHash = this.cryptomator.getCryptor().fileNameCryptor().hashDirectoryId(id);
            Path intermediate = new Path(this.dataRoot, directoryIdHash.substring(0, 2), this.dataRoot.getType());
            EnumSet<AbstractPath.Type> type = EnumSet.copyOf(directory.getType());
            type.add(AbstractPath.Type.encrypted);
            type.remove(AbstractPath.Type.decrypted);
            return new Path(intermediate, directoryIdHash.substring(2), type, attributes);
        }
        throw new NotfoundException(directory.getAbsolute());
    }

    private String toDirectoryId(Session<?> session, Path directory, String directoryId) throws BackgroundException {
        if (new SimplePathPredicate(this.home).test(directory)) {
            return ROOT_DIR_ID;
        }
        if (StringUtils.isBlank((CharSequence)directoryId)) {
            if (this.cache.containsKey(new DefaultPathPredicate(directory))) {
                return this.cache.get(new DefaultPathPredicate(directory));
            }
            String id = this.load(session, directory);
            this.cache.put((CacheReference<Path>)new DefaultPathPredicate(directory), id);
            return id;
        }
        this.cache.put((CacheReference<Path>)new DefaultPathPredicate(directory), directoryId);
        return directoryId;
    }

    private String load(Session<?> session, Path directory) throws BackgroundException {
        Path parent = this.toEncrypted(session, directory.getParent().attributes().getDirectoryId(), directory.getParent());
        String cleartextName = directory.getName();
        String ciphertextName = this.toEncrypted(session, parent.attributes().getDirectoryId(), cleartextName, EnumSet.of(AbstractPath.Type.directory));
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Read directory ID for folder %s from %s", directory, ciphertextName));
            }
            Path metadataFile = new Path(parent, ciphertextName, EnumSet.of(AbstractPath.Type.file, AbstractPath.Type.encrypted));
            return new ContentReader(session).read(metadataFile);
        }
        catch (NotfoundException e) {
            log.warn((Object)String.format("Missing directory ID for folder %s", directory));
            return this.random.random();
        }
    }

    public void delete(Path directory) {
        this.cache.remove(new DefaultPathPredicate(directory));
    }

    public void destroy() {
        this.cache.clear();
    }
}

