/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.RandomStringService;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.UUIDRandomStringService;
import ch.cyberduck.core.cryptomator.ContentWriter;
import ch.cyberduck.core.cryptomator.CryptoVault;
import ch.cyberduck.core.cryptomator.features.CryptoWriteFeature;
import ch.cyberduck.core.cryptomator.random.RandomNonceGenerator;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.random.NonceGenerator;
import ch.cyberduck.core.transfer.TransferStatus;
import java.nio.charset.Charset;
import org.apache.log4j.Logger;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.FileHeader;

public class CryptoDirectoryFeature<Reply>
implements Directory<Reply> {
    private static final Logger log = Logger.getLogger(CryptoDirectoryFeature.class);
    private final Session<?> session;
    private final Directory<Reply> proxy;
    private final CryptoVault vault;
    private final RandomStringService random = new UUIDRandomStringService();

    public CryptoDirectoryFeature(Session<?> session, Directory<Reply> delegate, Write<Reply> writer, CryptoVault cryptomator) {
        this.session = session;
        this.proxy = delegate.withWriter(new CryptoWriteFeature<Reply>(session, writer, cryptomator));
        this.vault = cryptomator;
    }

    public Path mkdir(Path folder, String region, TransferStatus status) throws BackgroundException {
        String directoryId = this.random.random();
        Path encrypt = this.vault.encrypt(this.session, folder, directoryId, false);
        Path directoryMetadataFile = this.vault.encrypt(this.session, folder, true);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Write metadata %s for folder %s", directoryMetadataFile, folder));
        }
        new ContentWriter(this.session).write(directoryMetadataFile, directoryId.getBytes(Charset.forName("UTF-8")));
        Path intermediate = encrypt.getParent();
        if (!((Find)this.session._getFeature(Find.class)).find(intermediate)) {
            ((Directory)this.session._getFeature(Directory.class)).mkdir(intermediate, region, new TransferStatus());
        }
        Cryptor cryptor = this.vault.getCryptor();
        FileHeader header = cryptor.fileHeaderCryptor().create();
        status.setHeader(cryptor.fileHeaderCryptor().encryptHeader(header));
        status.setNonces((NonceGenerator)new RandomNonceGenerator());
        Path target = this.proxy.mkdir(encrypt, region, status);
        target.attributes().setDirectoryId(directoryId);
        target.attributes().setDecrypted(encrypt.attributes().getDecrypted());
        Path decrypt = this.vault.decrypt(this.session, this.vault.encrypt(this.session, target, true));
        decrypt.attributes().setVersionId(target.attributes().getVersionId());
        return decrypt;
    }

    public boolean isSupported(Path workdir, String name) {
        return this.proxy.isSupported(workdir, name);
    }

    public CryptoDirectoryFeature<Reply> withWriter(Write<Reply> writer) {
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoDirectoryFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

