/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.synchronization;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.synchronization.ChecksumComparisonService;
import ch.cyberduck.core.synchronization.ComparePathFilter;
import ch.cyberduck.core.synchronization.Comparison;
import ch.cyberduck.core.synchronization.ComparisonService;
import ch.cyberduck.core.synchronization.SizeComparisonService;
import ch.cyberduck.core.synchronization.TimestampComparisonService;
import ch.cyberduck.core.transfer.TransferStatus;
import java.text.MessageFormat;
import java.util.TimeZone;

public class ComparisonServiceFilter
implements ComparePathFilter {
    private Find finder;
    private AttributesFinder attribute;
    private final ComparisonService checksum;
    private final ComparisonService size;
    private final ComparisonService timestamp;
    private final ProgressListener progress;

    public ComparisonServiceFilter(Session<?> session, TimeZone tz, ProgressListener listener) {
        this.finder = session.getFeature(Find.class, new DefaultFindFeature(session));
        this.attribute = session.getFeature(AttributesFinder.class, new DefaultAttributesFinderFeature(session));
        this.timestamp = new TimestampComparisonService(tz);
        this.size = new SizeComparisonService();
        this.checksum = new ChecksumComparisonService();
        this.progress = listener;
    }

    public ComparisonServiceFilter withFinder(Find finder) {
        this.finder = finder;
        return this;
    }

    public ComparisonServiceFilter withAttributes(AttributesFinder attribute) {
        this.attribute = attribute;
        return this;
    }

    public ComparisonServiceFilter withCache(Cache<Path> cache) {
        this.finder.withCache(cache);
        this.attribute.withCache(cache);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Comparison compare(Path file, Local local) throws BackgroundException {
        if (local.exists()) {
            Comparison comparison;
            if (!this.finder.find(file)) return Comparison.local;
            if (file.isDirectory()) {
                return Comparison.equal;
            }
            PathAttributes attributes = this.attribute.find(file);
            if (Checksum.NONE != attributes.getChecksum()) {
                this.progress.message(MessageFormat.format(LocaleFactory.localizedString("Compute MD5 hash of {0}", "Status"), file.getName()));
                local.attributes().setChecksum(ChecksumComputeFactory.get(attributes.getChecksum().algorithm).compute(local.getInputStream(), new TransferStatus()));
                comparison = this.checksum.compare(attributes, local.attributes());
                if (!Comparison.notequal.equals((Object)comparison)) {
                    return comparison;
                }
            }
            if (!Comparison.notequal.equals((Object)(comparison = this.size.compare(attributes, local.attributes())))) {
                return comparison;
            }
            comparison = this.timestamp.compare(attributes, local.attributes());
            if (Comparison.notequal.equals((Object)comparison)) return Comparison.equal;
            return comparison;
        }
        if (!this.finder.find(file)) return Comparison.equal;
        return Comparison.remote;
    }
}

