/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.aquaticprime;

import ch.cyberduck.core.Factory;
import ch.cyberduck.core.FactoryException;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.aquaticprime.DisabledLicenseVerifierCallback;
import ch.cyberduck.core.aquaticprime.License;
import ch.cyberduck.core.aquaticprime.LicenseVerifierCallback;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.preferences.SupportDirectoryFinderFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public abstract class LicenseFactory
extends Factory<License> {
    private static final Logger log = Logger.getLogger(LicenseFactory.class);
    private static final Preferences preferences = PreferencesFactory.get();
    protected final Local folder;
    private final Filter<Local> filter;
    public static final License EMPTY_LICENSE = new License(){

        @Override
        public boolean verify(LicenseVerifierCallback callback) {
            return false;
        }

        @Override
        public String getValue(String property) {
            return null;
        }

        @Override
        public String getName() {
            return LocaleFactory.localizedString("Not a valid registration key", "License");
        }

        @Override
        public boolean isReceipt() {
            return false;
        }

        public boolean equals(Object obj) {
            if (obj instanceof License) {
                return EMPTY_LICENSE == obj;
            }
            return false;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return LocaleFactory.localizedString("Not a valid registration key", "License");
        }
    };

    protected LicenseFactory() {
        this(SupportDirectoryFinderFactory.get().find());
    }

    protected LicenseFactory(Local folder) {
        this(folder, new LicenseFilter());
    }

    protected LicenseFactory(Local folder, Filter<Local> filter) {
        this.folder = folder;
        this.filter = filter;
    }

    protected abstract License open(Local var1);

    public List<License> open() throws AccessDeniedException {
        ArrayList<License> keys = new ArrayList<License>();
        if (this.folder.exists()) {
            for (Local key : this.folder.list().filter(this.filter)) {
                keys.add(this.open(key));
            }
        }
        return keys;
    }

    public static License get(Local file) {
        String clazz = preferences.getProperty("factory.licensefactory.class");
        if (null == clazz) {
            throw new FactoryException();
        }
        try {
            Class<?> name = Class.forName(clazz);
            return ((LicenseFactory)name.newInstance()).open(file);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new FactoryException(e.getMessage(), e);
        }
    }

    public static License find() {
        return LicenseFactory.find(new DisabledLicenseVerifierCallback());
    }

    public static License find(LicenseVerifierCallback callback) {
        try {
            String clazz = preferences.getProperty("factory.licensefactory.class");
            try {
                Class<?> name = Class.forName(clazz);
                ArrayList<License> list = new ArrayList<License>(((LicenseFactory)name.newInstance()).open());
                list.removeIf(key -> !key.verify(callback));
                if (list.isEmpty()) {
                    return EMPTY_LICENSE;
                }
                return (License)list.iterator().next();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new FactoryException(e.getMessage(), e);
            }
        }
        catch (AccessDeniedException e) {
            log.warn((Object)String.format("Failure finding receipt %s", e.getMessage()));
            return EMPTY_LICENSE;
        }
    }

    protected static final class LicenseFilter
    implements Filter<Local> {
        protected LicenseFilter() {
        }

        @Override
        public boolean accept(Local file) {
            return "cyberducklicense".equals(FilenameUtils.getExtension((String)file.getName()));
        }

        @Override
        public Pattern toPattern() {
            return Pattern.compile(".*\\.cyberducklicense");
        }
    }

    public static final class DefaultLicenseFactory
    extends Factory<License> {
        private final LicenseFactory delegate;

        public DefaultLicenseFactory(LicenseFactory delegate) {
            this.delegate = delegate;
        }

        @Override
        public License create() {
            try {
                List<License> list = this.delegate.open();
                if (list.isEmpty()) {
                    return EMPTY_LICENSE;
                }
                return list.iterator().next();
            }
            catch (AccessDeniedException e) {
                log.warn((Object)String.format("Failure finding receipt %s", e.getMessage()));
                return EMPTY_LICENSE;
            }
        }
    }
}

